<?php
namespace Mainto\Bridge\Enums\HimoSupplyChain;

class PurchaseShipNoticeStatusEnum {
    /**
     * 未发货:发货通知单总计已发数量为0
     */
    const WAIT_SHIP = 1;
    /**
     * 部分发货:发货通知单总计已发数量大于0，小于总计需发数量
     */
    const PART_SHIP = 2;
    /**
     * 部分发货完结:发货通知单总计已发数量大于0，未发货数量全被关闭
     */
    const PART_SHIP_COMPLETE = 3;
    /**
     * 完全发货:发货通知单总计已发数量等于总计需发数量
     */
    const SHIP_COMPLETE = 4;
    /**
     * 关闭:发货通知单被采购员关闭
     */
    const CLOSE = 5;
    /**
     * 加工完成
     */
    const PROCESS_COMPLETE = 6;
}