<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createReturnByParams(array $params)
 * @method purchaseReturnOutStorageByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 */
class PurchaseReturn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退货单
     *
     * @support  int $fromStorageId 退货方仓库 [ require true ]
     * @support  int $toStorageId 收货方仓库地址 [ require true ]
     * @support  int $noticeId  require false
     * @support  int $orderId  require false
     * @support  array $items  require false
     * @support  int $createRefund  require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createReturn () {
        return self::getClass()->createReturn();
    }

    /**
     * 退货单出库（预留接口）
     *
     * @support  int $returnId 退货单id [ require true ]
     * @support  int $operateId 操作人id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function purchaseReturnOutStorage () {
        return self::getClass()->purchaseReturnOutStorage();
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * getListPagination
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}