<?php
namespace Mainto\Bridge\Enums\HimoSupplyChain;

class PurchaseReturnStatusEnum {
    /**
     * 未发货:发货通知单总计已发数量为0
     */
    const CREATE = 'create';
    /**
     * 部分发货:发货通知单总计已发数量大于0，小于总计需发数量
     */
    const WAIT_OUT = 'wait_out';
    /**
     * 部分发货完结:发货通知单总计已发数量大于0，未发货数量全被关闭
     */
    const WAIT_RECEIVE = 'wait_receive';
    /**
     * 完全发货:发货通知单总计已发数量等于总计需发数量
     */
    const FINISH = 'finish';
    /**
     * 关闭:发货通知单被采购员关闭
     */
    const CLOSE = 'close';
}