<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseRefundByParams(array $params)
 * @method submitPurchaseRefundByParams(array $params)
 * @method updatePurchaseRefundByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 * @method getRefundItemCountByParams(array $params)
 */
class PurchaseRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款单创建
     *
     * @support  int $noticeId 应付款单号 require false
     * @support  int $orderId 采购单号 require false
     * @support  int $returnId 退货单id require false
     * @support  int $supplierId 供应商id [ require true ]
     * @support  int $createdBy 创建人 require false
     * @support  array $items 子单 require false
     * @support  float $refundMoney 退款金额 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseRefund () {
        return self::getClass()->createPurchaseRefund();
    }

    /**
     * 退款单提交/完成
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPurchaseRefund () {
        return self::getClass()->submitPurchaseRefund();
    }

    /**
     * 更新退款单
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @support  array $items 子单 [ require true ]
     * @support  float $refundMoney 退款金额 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePurchaseRefund () {
        return self::getClass()->updatePurchaseRefund();
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * getListPagination
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 根据noticemItemIds,orderItemIds,returnItemIds 来返回对应的退货单数量
     *
     * @support  array $noticeItemIds 发货通知单子单id require false
     * @support  array $orderItemIds 采购订单子单id require false
     * @support  array $returnItemIds 退货单子单id require false
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundItemCount () {
        return self::getClass()->getRefundItemCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}