<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method disableByParams(array $params)
 * @method enableByParams(array $params)
 * @method getMaterialSkusByParams(array $params)
 * @method getByIdsWithMaterialByParams(array $params)
 * @method getMaterialSkuIdsBySupplierIdByParams(array $params)
 * @method getSkuIdsByParams(array $params)
 * @method getMaterialSkuByBuyerByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method getMaterialSkuIdsByParams(array $params)
 * @method getMaterialIdsBySupplierIdByParams(array $params)
 * @method getOneByParams(array $params)
 * @method getBaseInfoBySkuNameByParams(array $params)
 * @method getMaterialSkuByBuyerIdByParams(array $params)
 * @method getMaterialIdsByIdsByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method getMaterialSkuListByParams(array $params)
 */
class MaterialSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭物料sku
     *
     * @param  int $skuId 物料skuid [ require true ]
     * @param  int $updateBy 更新者 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disable (int $skuId, int $updateBy) {
        return self::getClass()->disable([
            "skuId" => $skuId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 启用物料sku
     *
     * @param  int $skuId 物料skuids [ require true ]
     * @param  int $updateBy 更新者 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enable (int $skuId, int $updateBy) {
        return self::getClass()->enable([
            "skuId" => $skuId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 得到物料skus
     *
     * @param  array $ids 物料skuids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkus (array $ids) {
        return self::getClass()->getMaterialSkus([
            "ids" => $ids,
        ]);
    }

    /**
     * 得到物料skus
     *
     * @param  array $ids 物料skuids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIdsWithMaterial (array $ids) {
        return self::getClass()->getByIdsWithMaterial([
            "ids" => $ids,
        ]);
    }

    /**
     * 通过供应商id得到物料skuIds
     *
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkuIdsBySupplierId (int $supplierId = 0) {
        return self::getClass()->getMaterialSkuIdsBySupplierId([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 通过供应商id得到物料skuIds
     *
     * @support  int $supplierId 供应商id require false
     * @support  int $buyerId 采购员id require false
     * @support  string $deliveryType 发货方式 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuIds () {
        return self::getClass()->getSkuIds();
    }

    /**
     * 通过购买者id得到供应商id列表
     *
     * @param  int $buyerId 购买者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkuByBuyer (int $buyerId) {
        return self::getClass()->getMaterialSkuByBuyer([
            "buyerId" => $buyerId,
        ]);
    }

    /**
     * 物料上架
     *
     * @param  int $id 物料skuid [ require true ]
     * @param  string $status 物料状态 [ require true ]
     * @param  int $updateBy 更新员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function shelve (int $id, string $status, int $updateBy) {
        return self::getClass()->shelve([
            "id" => $id,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 物料下架
     *
     * @param  int $id 物料skuid [ require true ]
     * @param  string $status 物料状态 [ require true ]
     * @param  int $updateBy 更新员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve (int $id, string $status, int $updateBy) {
        return self::getClass()->unshelve([
            "id" => $id,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 批量物料下架
     *
     * @param  array $ids 物料ids [ require true ]
     * @param  string $status 物料状态 [ require true ]
     * @param  int $updateBy 更新员工id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUnshelve (array $ids, string $status, int $updateBy) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 得到物料skuIds
     *
     * @support  int $supplierId 供应商id require false
     * @support  int $buyerId 采购员id require false
     * @support  string $deliveryType 发货方式 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkuIds () {
        return self::getClass()->getMaterialSkuIds();
    }

    /**
     * 通过供应商id得到物料id列表
     *
     * @param  int $supplierId 供应商id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialIdsBySupplierId (int $supplierId) {
        return self::getClass()->getMaterialIdsBySupplierId([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 得到一个物料sku
     *
     * @param  array $data 查询条件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOne (array $data) {
        return self::getClass()->getOne([
            "data" => $data,
        ]);
    }

    /**
     * 得到物料基本信息
     *
     * @param  string $skuName 物料名称 [ require true ]
     * @param  int $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseInfoBySkuName (string $skuName, int $source) {
        return self::getClass()->getBaseInfoBySkuName([
            "skuName" => $skuName,
            "source" => $source,
        ]);
    }

    /**
     * 通过员工id得到物料sku
     *
     * @param  int $loginStaffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkuByBuyerId (int $loginStaffId) {
        return self::getClass()->getMaterialSkuByBuyerId([
            "loginStaffId" => $loginStaffId,
        ]);
    }

    /**
     * 通过skuIds得到物料ids
     *
     * @param  array $ids skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialIdsByIds (array $ids) {
        return self::getClass()->getMaterialIdsByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 通过物料ID和状态获取SKU
     *
     * @param  int $id 物料ID [ require true ]
     * @param  string $status 物料状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkusByMaterialId (int $id, string $status) {
        return self::getClass()->getSkusByMaterialId([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 通过物料ID和状态获取SKU
     *
     * @param  array $params 物料sku参数 [ require true ]
     * @param  array $source 物料来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkuList (array $source, array $params = []) {
        return self::getClass()->getMaterialSkuList([
            "source" => $source,
            "params" => $params,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'MaterialSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'MaterialSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}