<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setReceiveKeyNameByParams(array $params)
 * @method addReceiveLogisticByParams(array $params)
 * @method listByParams(array $params)
 * @method listAllByParams(array $params)
 * @method getPurchaseReceivelistByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method allItemListByParams(array $params)
 * @method receiveShipByParams(array $params)
 * @method batchReceiveShipByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method exceptionListByParams(array $params)
 * @method handleExceptionByFromByParams(array $params)
 * @method handleExceptionByToByParams(array $params)
 * @method closeByParams(array $params)
 * @method updateWaitCountByParams(array $params)
 * @method receiveByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemsByOrderItemIdsByParams(array $params)
 * @method getItemsByDemandItemIdsByParams(array $params)
 * @method getItemsByReceiveIdsByParams(array $params)
 * @method exceptionStateByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method confirmPurchasePlanByParams(array $params)
 */
class Receive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置收货单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReceiveKeyName () {
        return self::getClass()->setReceiveKeyName();
    }

    /**
     * 新增发货单物流
     *
     * @param  int $receiveId 发货单id [ require true ]
     * @param  array $trackingNumbers 物流单号数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addReceiveLogistic (int $receiveId, array $trackingNumbers) {
        return self::getClass()->addReceiveLogistic([
            "receiveId" => $receiveId,
            "trackingNumbers" => $trackingNumbers,
        ]);
    }

    /**
     * 收货列表
     *
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  string $receiveNo 收货单号 require false
     * @support  int $fromStorageId 发货仓库id require false
     * @support  string $trackingNumber 物流单号 require false
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  string $skuCode sku编码 require false
     * @support  string $barcode 条形码 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 收货数据全部
     *
     * @support  array $toStorageId 收货仓库id [ require true ]
     * @support  string $receiveNo 收货单号 require false
     * @support  int $fromStorageId 发货仓库id require false
     * @support  string $trackingNumber 物流单号 require false
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 require false
     * @support  string $skuName sku名称 require false
     * @support  string $skuCode sku编码 require false
     * @support  string $barcode 条形码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function listAll () {
        return self::getClass()->listAll();
    }

    /**
     * 获取采购类型的收货列表
     *
     * @support  string $receiveNo 收货单号 require false
     * @support  string $noticeNo 发货通知单号 require false
     * @support  string $createdAtStart 创建开始时间 require false
     * @support  string $createdAtEnd 创建结束时间 require false
     * @support  int $toStorageId 收货方id require false
     * @support  int $createBy 创建人工号 require false
     * @support  int $status 状态 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseReceivelist (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPurchaseReceivelist([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取发货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 发货单子单据列表
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发货单子单据列表
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 require false
     * @support  string $skuCode sku编码 require false
     * @throws  \Exception
     * @return  array
     */
    public static function allItemList () {
        return self::getClass()->allItemList();
    }

    /**
     * 收货
     *
     * @param  int $id 发货单id [ require true ]
     * @param  array $itemList 发货单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $toStaffId 收货人id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveShip (int $id, array $itemList, int $operateId, int $toStaffId) {
        return self::getClass()->receiveShip([
            "id" => $id,
            "itemList" => $itemList,
            "operateId" => $operateId,
            "toStaffId" => $toStaffId,
        ]);
    }

    /**
     * 收货
     *
     * @param  array $data 操作人ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchReceiveShip (array $data, int $operateId) {
        return self::getClass()->batchReceiveShip([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取发货单详情
     *
     * @param  string $receiveNo 收货单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNo (string $receiveNo) {
        return self::getClass()->detailByNo([
            "receiveNo" => $receiveNo,
        ]);
    }

    /**
     * 收货异常列表
     *
     * @support  int $fromStorageId 发货仓库id require false
     * @support  int $toStorageId 收货仓库id require false
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 require false
     * @support  array $sources 仓库归属方 1是总部，2是门店，3是供应商 require false
     * @support  string $receiveNo 收货单号 require false
     * @support  int $status 状态 1提交，2处理完成 require false
     * @support  string $skuName sku名字 require false
     * @support  int $handler 异常处理人 1是发货方 2是总部 [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exceptionList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->exceptionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 异常归属发货方处理逻辑
     *
     * @param  int $receiveItemId 发货单明细id [ require true ]
     * @param  int $skuId skuId [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $errorNum 异常处理数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleExceptionByFrom (int $receiveItemId, int $skuId, int $operateId, int $errorNum) {
        return self::getClass()->handleExceptionByFrom([
            "receiveItemId" => $receiveItemId,
            "skuId" => $skuId,
            "operateId" => $operateId,
            "errorNum" => $errorNum,
        ]);
    }

    /**
     * 异常归属收货方处理逻辑
     *
     * @param  int $receiveItemId 发货单明细id [ require true ]
     * @param  int $skuId skuId [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $errorNum 异常处理数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleExceptionByTo (int $receiveItemId, int $skuId, int $operateId, int $errorNum) {
        return self::getClass()->handleExceptionByTo([
            "receiveItemId" => $receiveItemId,
            "skuId" => $skuId,
            "operateId" => $operateId,
            "errorNum" => $errorNum,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $updateBy 修改人工号 [ require true ]
     * @param  int $receiveId 收货单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $updateBy, int $receiveId) {
        return self::getClass()->close([
            "updateBy" => $updateBy,
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 更新待收货数量
     *
     * @param  int $updateBy 修改人工号 [ require true ]
     * @param  array $data 收货数量信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateWaitCount (int $updateBy, array $data) {
        return self::getClass()->updateWaitCount([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量收货
     *
     * @param  int $updateBy 修改人工号 [ require true ]
     * @param  array $data 收货单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receive (int $updateBy, array $data) {
        return self::getClass()->receive([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 根据采购单明细ids获取收货明细信息
     *
     * @param  array $orderItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getItemsByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * 根据需求单明细ids获取收货明细信息
     *
     * @param  array $demandItemIds 需求单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByDemandItemIds (array $demandItemIds) {
        return self::getClass()->getItemsByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 根据收货单ids 获取收货明细分页数据
     *
     * @param  array $receiveIds 需求单itemids [ require true ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByReceiveIds (array $receiveIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemsByReceiveIds([
            "receiveIds" => $receiveIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 异常申述（处理人变更）
     *
     * @param  int $id 异常id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exceptionState (int $id, int $operateId) {
        return self::getClass()->exceptionState([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 收货单导入模板
     *
     * @param  array $receiveIds 收货单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $receiveIds) {
        return self::getClass()->importTemplate([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 导入待收货数量
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function import (int $updateBy, array $data) {
        return self::getClass()->import([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 零售总仓发货1调拨2采购-wms回调
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmPurchasePlan (array $data) {
        return self::getClass()->confirmPurchasePlan([
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Receive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Receive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}