<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method updatePrepaidMoneyByParams(array $params)
 * @method closeByParams(array $params)
 * @method revokeByParams(array $params)
 * @method submitByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method createByParams(array $params)
 * @method payByParams(array $params)
 * @method approveByParams(array $params)
 * @method getTotalPaidByParams(array $params)
 * @method getByOrderIdByParams(array $params)
 * @method getByOrderIdsByParams(array $params)
 */
class PurchaseAdvance {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $orderNo 采购单号 require false
     * @support  string $createdAtStart 创建开始时间 require false
     * @support  string $createdAtEnd 创建结束时间 require false
     * @support  int $createBy 创建人工号 require false
     * @support  string $approveStatus 审批状态 require false
     * @support  string $status 付款状态 require false
     * @support  int $supplierId 供应商id require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @support  string $orderId 采购单Id require false
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $advanceId) {
        return self::getClass()->detail([
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $advanceId 预付款单id [ require true ]
     * @support  int $supplierBankId 供应商账户id require false
     * @support  string $prepaidRate 预付比例 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $advanceId, int $updateBy) {
        return self::getClass()->update([
            "advanceId" => $advanceId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 更新预付金额
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $advanceId 预付款单id [ require true ]
     * @param  float $prepaidMoney 预付金额 [ require true ]
     * @param  int $supplierBankId 供应商银行账户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updatePrepaidMoney (float $prepaidMoney, int $advanceId, int $supplierBankId = 0, int $updateBy) {
        return self::getClass()->updatePrepaidMoney([
            "prepaidMoney" => $prepaidMoney,
            "advanceId" => $advanceId,
            "supplierBankId" => $supplierBankId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $updateBy, int $advanceId) {
        return self::getClass()->close([
            "updateBy" => $updateBy,
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 撤销审批
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $advanceId 预付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (int $updateBy, int $advanceId) {
        return self::getClass()->revoke([
            "updateBy" => $updateBy,
            "advanceId" => $advanceId,
        ]);
    }

    /**
     * 提交审批
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $advanceId 预付款单id [ require true ]
     * @param  string $processInstanceId 审批id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $updateBy, int $advanceId, string $processInstanceId) {
        return self::getClass()->submit([
            "updateBy" => $updateBy,
            "advanceId" => $advanceId,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 创建预付款单
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  int $createBy 创建人工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (int $orderId, int $createBy) {
        return self::getClass()->create([
            "orderId" => $orderId,
            "createBy" => $createBy,
        ]);
    }

    /**
     * 更新付款
     *
     * @param  string $advanceNo 单号 [ require true ]
     * @param  string $status 付款状态 [ require true ]
     * @param  mixed $paidMoney 付款金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pay (string $advanceNo, string $status, $paidMoney) {
        return self::getClass()->pay([
            "advanceNo" => $advanceNo,
            "status" => $status,
            "paidMoney" => $paidMoney,
        ]);
    }

    /**
     * 更新审批
     *
     * @param  string $processInstanceId 审批id [ require true ]
     * @param  string $approveStatus 审批状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approve (string $processInstanceId, string $approveStatus) {
        return self::getClass()->approve([
            "processInstanceId" => $processInstanceId,
            "approveStatus" => $approveStatus,
        ]);
    }

    /**
     * 获取采购单已预付金额
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getTotalPaid (int $orderId) {
        return self::getClass()->getTotalPaid([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据订单id获取预付单信息
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByOrderId (int $orderId) {
        return self::getClass()->getByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据订单ids获取预付单信息
     *
     * @param  array $orderIds 采购单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByOrderIds (array $orderIds) {
        return self::getClass()->getByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseAdvance');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseAdvance');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}