<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method sendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemsByOrderItemIdsByParams(array $params)
 * @method getItemsByDemandItemIdsByParams(array $params)
 * @method getItemsByItemIdsByParams(array $params)
 * @method getByIdsByParams(array $params)
 * @method getItemsByStatusAndNoticeIdsByParams(array $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $noticeNo 发货通知单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  int $shipBy 发货方 [Original type uint] 
     * @support  array $status 状态 
     * @support  int $source 来源2成品3原料 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $noticeId) {
        return self::getClass()->detail([
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $updateBy 操作人工号 [Original type uint] [ require true ]
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @param  string $planDate 预计到货时间 [ require true ]
     * @param  string $trackingNumber 物流单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $updateBy, int $noticeId, string $planDate = '', string $trackingNumber = '') {
        return self::getClass()->update([
            "updateBy" => $updateBy,
            "noticeId" => $noticeId,
            "planDate" => $planDate,
            "trackingNumber" => $trackingNumber,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $noticeId 采购单id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $noticeId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "noticeId" => $noticeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function import (int $updateBy, array $data) {
        return self::getClass()->import([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  int $createBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSend (int $createBy, array $noticeIds) {
        return self::getClass()->batchSend([
            "createBy" => $createBy,
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 发运
     *
     * @param  int $createBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function send (int $createBy, array $noticeId) {
        return self::getClass()->send([
            "createBy" => $createBy,
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (int $updateBy, array $data) {
        return self::getClass()->batchUpdate([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $data 待关闭的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (int $updateBy, array $data) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $orderItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getItemsByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $demandItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByDemandItemIds (array $demandItemIds) {
        return self::getClass()->getItemsByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $itemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByItemIds (array $itemIds) {
        return self::getClass()->getItemsByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $ids 通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIds (array $ids) {
        return self::getClass()->getByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $status status [ require true ]
     * @param  array $noticeIds noticeIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByStatusAndNoticeIds (array $status, array $noticeIds) {
        return self::getClass()->getItemsByStatusAndNoticeIds([
            "status" => $status,
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}