<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchImportByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method existsByRetailProductIdByParams(array $params)
 */
class Bom {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建bom
     *
     * @support  int $createBy createBy [Original type uint] 
     * @support  int $retailProductId 零售商品id [Original type uint] 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  array $items items 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改bom
     *
     * @support  int $updateBy updateBy [Original type uint] 
     * @support  int $id id [Original type uint] 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  array $items items 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 批量创建bom
     *
     * @param  int $createBy createBy [Original type uint] [ require true ]
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (int $createBy, array $data) {
        return self::getClass()->batchCreate([
            "createBy" => $createBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量导入bom
     *
     * @param  int $updateBy updateBy [Original type uint] [ require true ]
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchImport (int $updateBy, array $data) {
        return self::getClass()->batchImport([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * bom列表
     *
     * @support  string $code code 
     * @support  string $name name 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  int $materialId materialId [Original type uint] 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * bom详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * bom是否存在
     *
     * @param  int $retailProductId 零售商品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function existsByRetailProductId (int $retailProductId) {
        return self::getClass()->existsByRetailProductId([
            "retailProductId" => $retailProductId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Bom');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Bom');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}