<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Bom {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建bom
     *
     * @support  int $createBy createBy [Original type uint] 
     * @support  string $code code 
     * @support  string $name name 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  array $items items 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改bom
     *
     * @support  int $updateBy updateBy [Original type uint] 
     * @support  int $id id [Original type uint] 
     * @support  string $bomCode bomCode 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  array $items items 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 批量创建bom
     *
     * @param  int $createBy createBy [Original type uint] [ require true ]
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (int $createBy, array $data) {
        return self::getClass()->batchCreate([
            "createBy" => $createBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量修改bom
     *
     * @param  int $updateBy updateBy [Original type uint] [ require true ]
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (int $updateBy, array $data) {
        return self::getClass()->batchUpdate([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * bom列表
     *
     * @support  string $code code 
     * @support  string $name name 
     * @support  int $supplierId supplierId [Original type uint] 
     * @support  int $materialId materialId [Original type uint] 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * bom详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除bom
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Bom');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Bom');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}