<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method submitByParams(array $params)
 * @method closeByParams(array $params)
 * @method getItemsByItemIdsByParams(array $params)
 * @method getByIdsByParams(array $params)
 * @method firstByIdByParams(array $params)
 * @method firstByIdWithAdvanceByParams(array $params)
 * @method updateOrderItemByParams(array $params)
 * @method updatePrepaidRateByParams(array $params)
 */
class PurchaseOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $orderNo 采购单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $orderId) {
        return self::getClass()->detail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $orderId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "orderId" => $orderId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  int $supplierId 供应商id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $updateBy, int $orderId, int $supplierId) {
        return self::getClass()->update([
            "updateBy" => $updateBy,
            "orderId" => $orderId,
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 提交(生成发货通知单)
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $updateBy, int $orderId) {
        return self::getClass()->submit([
            "updateBy" => $updateBy,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  array $orderItemIds 采购单明细id [ require true ]
     * @param  int $closeCount 关闭数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $updateBy, int $orderId, array $orderItemIds, int $closeCount) {
        return self::getClass()->close([
            "updateBy" => $updateBy,
            "orderId" => $orderId,
            "orderItemIds" => $orderItemIds,
            "closeCount" => $closeCount,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $itemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByItemIds (array $itemIds) {
        return self::getClass()->getItemsByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $ids 通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIds (array $ids) {
        return self::getClass()->getByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function firstById (int $id) {
        return self::getClass()->firstById([
            "id" => $id,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstByIdWithAdvance (int $id) {
        return self::getClass()->firstByIdWithAdvance([
            "id" => $id,
        ]);
    }

    /**
     * 修改明细信息
     *
     * @param  int $updateBy 操作人 [Original type uint] [ require true ]
     * @param  array $data 修改的数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateOrderItem (int $updateBy, array $data) {
        return self::getClass()->updateOrderItem([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 用于补漏的物料库存初始化
     *
     * @param  int $updateBy 操作人工号 [ require true ]
     * @param  int $orderId 采购单id [ require true ]
     * @param  float $prepaidRate 预付款比例 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePrepaidRate (int $updateBy, int $orderId, float $prepaidRate) {
        return self::getClass()->updatePrepaidRate([
            "updateBy" => $updateBy,
            "orderId" => $orderId,
            "prepaidRate" => $prepaidRate,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}