<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method missionListByParams(array $params)
 * @method missionDetailByParams(array $params)
 * @method missionCreateByParams(array $params)
 * @method missionRevokeByParams(array $params)
 * @method missionProcessByParams(array $params)
 * @method missionProcessRateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method saveByParams(array $params)
 * @method approveByParams(array $params)
 * @method noticeByParams(array $params)
 */
class Inventory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 盘点任务列表
     *
     * @support  string $missionNo 任务单号 
     * @support  string $createStart 创建时间开始 
     * @support  string $createEnd 创建时间结束 
     * @support  string $inventoryStart 盘点日期开始 
     * @support  string $inventoryEnd 盘点日期结束 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->missionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点任务详情
     *
     * @param  int $missionId 任务ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionDetail (int $missionId) {
        return self::getClass()->missionDetail([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 新增盘点任务
     *
     * @support  string $inventoryStart 盘点日期开始 [ require true ]
     * @support  string $inventoryEnd 盘点日期结束 [ require true ]
     * @support  string $remark 备注 
     * @support  int $allSku 是否所有商品 [Original type uint] 
     * @support  int $allStore 是否所有门店 [Original type uint] 
     * @support  array $storeIds 盘点门店ID数组 
     * @support  array $skuIds 盘点商品ID数组 
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionCreate () {
        return self::getClass()->missionCreate();
    }

    /**
     * 盘点任务撤回
     *
     * @param  int $missionId 任务ID [Original type uint] [ require true ]
     * @param  int $updateBy 修改人ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionRevoke (int $missionId, int $updateBy) {
        return self::getClass()->missionRevoke([
            "missionId" => $missionId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 盘点进度
     *
     * @support  int $missionId 任务ID [Original type uint] [ require true ]
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  string $status 状态 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionProcess (int $page = 1, int $pageSize = 10) {
        return self::getClass()->missionProcess([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点进度计算
     *
     * @param  int $missionId 任务ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionProcessRate (int $missionId) {
        return self::getClass()->missionProcessRate([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 盘点结果
     *
     * @support  string $inventoryStart 盘点日期开始 
     * @support  string $inventoryEnd 盘点日期结束 
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  int $isDifferent 有无差异 1有 [Original type uint] 
     * @support  string $inventoryType 盘点类型 
     * @support  string $status 提交状态 
     * @support  string $approveStatus 审核状态 
     * @support  int $createBy 提交人 [Original type uint] 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 盘点详情
     *
     * @param  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $inventoryId) {
        return self::getClass()->detail([
            "inventoryId" => $inventoryId,
        ]);
    }

    /**
     * 盘点明细
     *
     * @param  int $inventoryId 盘点ID [Original type uint] [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $inventoryId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "inventoryId" => $inventoryId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 新增盘点
     *
     * @support  int $inventoryId 盘点ID [Original type uint] 
     * @support  int $createBy 创建人 [Original type uint] [ require true ]
     * @support  int $storeId 门店ID [Original type uint] [ require true ]
     * @support  string $inventoryType 盘点类型 [ require true ]
     * @support  array $skuInfos 盘点商品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * 盘点审批通过
     *
     * @param  array $inventoryIds 盘点IDs [ require true ]
     * @param  int $approveBy 审核人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approve (array $inventoryIds, int $approveBy) {
        return self::getClass()->approve([
            "inventoryIds" => $inventoryIds,
            "approveBy" => $approveBy,
        ]);
    }

    /**
     * 盘点提醒
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function notice (int $storeId) {
        return self::getClass()->notice([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Inventory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Inventory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}