<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRetailByParams(array $params)
 * @method getDemandListByParams(array $params)
 * @method batchDealByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array $params)
 * @method getItemByItemIdsByParams(array $params)
 * @method getPurchaseDemandItemsByParams(array $params)
 * @method getOneByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method findItemOrFailByDemandIdByParams(array $params)
 * @method getPurchaseDemandsByIdsByParams(array $params)
 * @method getDemandSByStoreIdAndTypeByParams(array $params)
 */
class PurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @support  int $departmentId 部门id [Original type uint] 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $toStorageId 仓库id [Original type uint] 
     * @support  string $status 状态 
     * @support  string $type 类型 
     * @support  int $source 来源 [Original type uint] 
     * @support  string $remark 备注 
     * @support  array $items items 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRetail (int $createBy) {
        return self::getClass()->createRetail([
            "createBy" => $createBy,
        ]);
    }

    /**
     * 需求单列表
     *
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @support  string $type 类型 
     * @support  array $source 单据类型:1物料2成品3原料 
     * @support  string $demandNo 需求单号 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 单据状态 
     * @support  int $createBy 申请人工号 [Original type uint] 
     * @support  int $skuId 物料skuId [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "storeId" => $storeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 批量处理
     *
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDeal (int $createBy, array $demandItemIds) {
        return self::getClass()->batchDeal([
            "createBy" => $createBy,
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (int $updateBy, array $demandItemIds, string $closeReason) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
        ]);
    }

    /**
     * 明细列表
     *
     * @support  string $demandNo 需求单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $toStorageId 收货方id [Original type uint] 
     * @support  array $materialIds 物料ids 
     * @support  array $skuIds sku ids 
     * @support  array $status 状态 
     * @support  string $approveAtStart 审批通过开始时间 
     * @support  string $approveAtEnd 审批通过结束时间 
     * @support  string $type 采购类型 
     * @support  int $source 单据类型:1物料2成品3原料 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据需求单明细ids获取需求单明细信息
     *
     * @param  array $itemIds 需求单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemByItemIds (array $itemIds) {
        return self::getClass()->getItemByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 根据需求单明细ids获取需求单明细信息
     *
     * @support  array $itemIds 需求单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseDemandItems () {
        return self::getClass()->getPurchaseDemandItems();
    }

    /**
     * 通过需求单id得到一个需求单
     *
     * @param  int $demandId 需求单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOne (int $demandId) {
        return self::getClass()->getOne([
            "demandId" => $demandId,
        ]);
    }

    /**
     * 钉钉回调处理
     *
     * @param  string $eventType 事件类型 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $result 钉钉回调结果 [ require true ]
     * @param  string $processInstanceId 钉钉实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callbackDingProcess (string $eventType, string $type, string $processInstanceId, string $result = '') {
        return self::getClass()->callbackDingProcess([
            "eventType" => $eventType,
            "type" => $type,
            "processInstanceId" => $processInstanceId,
            "result" => $result,
        ]);
    }

    /**
     * 通过需求单id得到一个需求单详情列表
     *
     * @param  int $demandId 需求单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findItemOrFailByDemandId (int $demandId) {
        return self::getClass()->findItemOrFailByDemandId([
            "demandId" => $demandId,
        ]);
    }

    /**
     * 通过需求单ids得到一个需求单列表
     *
     * @param  array $demandIds 需求单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseDemandsByIds (array $demandIds) {
        return self::getClass()->getPurchaseDemandsByIds([
            "demandIds" => $demandIds,
        ]);
    }

    /**
     * 通过门店类型和门店id得到一个需求单
     *
     * @param  int $storeId 需求单ids [Original type uint] [ require true ]
     * @param  string $type 门店类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandSByStoreIdAndType (int $storeId, string $type) {
        return self::getClass()->getDemandSByStoreIdAndType([
            "storeId" => $storeId,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}