<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method disableByParams(array $params)
 * @method enableByParams(array $params)
 * @method getMaterialSkusByParams(array $params)
 * @method getByIdsWithMaterialByParams(array $params)
 * @method getMaterialSkuIdsBySupplierIdByParams(array $params)
 * @method getSkuIdsByParams(array $params)
 * @method getMaterialSkuByBuyerByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method getMaterialSkuIdsByParams(array $params)
 * @method getMaterialIdsBySupplierIdByParams(array $params)
 * @method getOneByParams(array $params)
 * @method getBaseInfoBySkuNameByParams(array $params)
 * @method getMaterialSkuByBuyerIdByParams(array $params)
 */
class MaterialSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭物料sku
     *
     * @param  int $skuId 物料skuid [ require true ]
     * @param  int $updateBy 更新者 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disable (int $skuId, int $updateBy) {
        return self::getClass()->disable([
            "skuId" => $skuId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 启用物料sku
     *
     * @param  int $skuId 物料skuids [ require true ]
     * @param  int $updateBy 更新者 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enable (int $skuId, int $updateBy) {
        return self::getClass()->enable([
            "skuId" => $skuId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 得到物料skus
     *
     * @param  array $ids 物料skuids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkus (array $ids) {
        return self::getClass()->getMaterialSkus([
            "ids" => $ids,
        ]);
    }

    /**
     * 得到物料skus
     *
     * @param  array $ids 物料skuids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByIdsWithMaterial (array $ids) {
        return self::getClass()->getByIdsWithMaterial([
            "ids" => $ids,
        ]);
    }

    /**
     * 通过供应商id得到物料skuIds
     *
     * @param  int $supplierId 供应商id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkuIdsBySupplierId (int $supplierId) {
        return self::getClass()->getMaterialSkuIdsBySupplierId([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 通过供应商id得到物料skuIds
     *
     * @param  array $params 参数数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuIds (array $params) {
        return self::getClass()->getSkuIds([
            "params" => $params,
        ]);
    }

    /**
     * 通过购买者id得到供应商id列表
     *
     * @param  int $buyerId 购买者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkuByBuyer (int $buyerId) {
        return self::getClass()->getMaterialSkuByBuyer([
            "buyerId" => $buyerId,
        ]);
    }

    /**
     * 物料上架
     *
     * @param  int $skuId 物料skuid [Original type uint] [ require true ]
     * @param  int $status 物料状态 [Original type uint] [ require true ]
     * @param  int $updateBy 更新员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function shelve (int $skuId, int $status, int $updateBy) {
        return self::getClass()->shelve([
            "skuId" => $skuId,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 物料下架
     *
     * @param  int $skuId 物料skuid [Original type uint] [ require true ]
     * @param  int $status 物料状态 [Original type uint] [ require true ]
     * @param  int $updateBy 更新员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unshelve (int $skuId, int $status, int $updateBy) {
        return self::getClass()->unshelve([
            "skuId" => $skuId,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 批量物料下架
     *
     * @param  int $ids 物料id [Original type uint] [ require true ]
     * @param  int $status 物料状态 [Original type uint] [ require true ]
     * @param  int $updateBy 更新员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUnshelve (int $ids, int $status, int $updateBy) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
            "status" => $status,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 得到物料skuIds
     *
     * @param  array $data 物料查询参数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkuIds (array $data) {
        return self::getClass()->getMaterialSkuIds([
            "data" => $data,
        ]);
    }

    /**
     * 通过供应商id得到物料id列表
     *
     * @param  int $supplierId 供应商id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialIdsBySupplierId (int $supplierId) {
        return self::getClass()->getMaterialIdsBySupplierId([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 得到一个物料sku
     *
     * @param  array $data 查询条件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOne (array $data) {
        return self::getClass()->getOne([
            "data" => $data,
        ]);
    }

    /**
     * 得到物料基本信息
     *
     * @param  string $skuName 物料名称 [ require true ]
     * @param  int $source 物料来源 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseInfoBySkuName (string $skuName, int $source) {
        return self::getClass()->getBaseInfoBySkuName([
            "skuName" => $skuName,
            "source" => $source,
        ]);
    }

    /**
     * 通过员工id得到物料sku
     *
     * @param  int $loginStaffId 员工id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkuByBuyerId (int $loginStaffId) {
        return self::getClass()->getMaterialSkuByBuyerId([
            "loginStaffId" => $loginStaffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'MaterialSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'MaterialSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}