<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplierBanksByParams(array $params)
 * @method getSupplierBankByParams(array $params)
 */
class SupplierBank {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 得到供应商银行帐号
     *
     * @support  array $ids 银行帐号ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplierBanks () {
        return self::getClass()->getSupplierBanks();
    }

    /**
     * 根据供应商ID获取银行账户
     *
     * @param  int $supplierId 供应商ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplierBank (int $supplierId) {
        return self::getClass()->getSupplierBank([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'SupplierBank');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'SupplierBank');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}