<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUnitsByParams(array $params)
 * @method syncUnitByParams(array $params)
 * @method getOrderUnitsByParams(array $params)
 * @method getUnitsListByParams(array $params)
 * @method getUnitsOrderByIdByParams(array $params)
 */
class Units {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取sku的数量单位信息
     *
     * @support  string $id id 
     * @support  array $ids ids 
     * @support  string $name 名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUnits () {
        return self::getClass()->getUnits();
    }

    /**
     * 同步sku的数量单位信息
     *
     * @support  string $name 单位名称 
     * @support  int $nsId nsId 
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncUnit () {
        return self::getClass()->syncUnit();
    }

    /**
     * map单位
     *
     * @support  string $name 单位名称 
     * @support  int $nsId nsId 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderUnits () {
        return self::getClass()->getOrderUnits();
    }

    /**
     * 获取sku的数量单位信息
     *
     * @support  string $id id 
     * @support  array $ids ids 
     * @support  string $name 名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUnitsList () {
        return self::getClass()->getUnitsList();
    }

    /**
     * 获取sku的数量单位信息
     *
     * @support  string $id id 
     * @support  array $ids ids 
     * @support  string $name 名称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUnitsOrderById () {
        return self::getClass()->getUnitsOrderById();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Units');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Units');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}