<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method countByParams(array $params)
 * @method listByParams(array $params)
 * @method allocationCreateByListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method itemListByParams(array $params)
 * @method allItemListByParams(array $params)
 * @method setAllocationNameByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method allocationShipByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 * @method closeAllocationByIdsByParams(array $params)
 * @method itemListByDemandItemIdsByParams(array $params)
 * @method allocationsRetryToEbsByParams(array $params)
 * @method confirmSalePlanByParams(array $params)
 * @method receiveRetryToEbsByParams(array $params)
 */
class Allocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取调拨单数量
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @support  int $createType 调拨单创建方1是总部2是门店 
     * @support  string $allocationType 单据类型 
     * @support  array $allocationTypes 单据类型数组 
     * @support  int $fromStorageId 发货仓库id 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * 调拨单列表
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @support  int $createType 调拨单创建方1是总部2是门店 
     * @support  string $createdAtStart 创建时间开始 
     * @support  string $createdAtEnd 创建时间结束 
     * @support  int $createBy 创建人id 
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型 
     * @support  array $allocationTypes 单据类型数组 
     * @support  int $fromStorageId 发货仓库id 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 调拨单列表
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @support  array $allocationTypes 单据类型数组 
     * @throws  \Exception
     * @return  array
     */
    public static function allocationCreateByList () {
        return self::getClass()->allocationCreateByList();
    }

    /**
     * 获取调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取调拨单号详情
     *
     * @param  string $allocationNo 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByNo (string $allocationNo) {
        return self::getClass()->detailByNo([
            "allocationNo" => $allocationNo,
        ]);
    }

    /**
     * 调拨单子单据列表--分页
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 调拨单子单据列表--不分页
     *
     * @support  int $id 调拨单id 
     * @support  array $ids 调拨单id列表 
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @support  array $withInfo with关联的信息结构如：[&#039;sku&#039;,&#039;allocation&#039;] 
     * @throws  \Exception
     * @return  array
     */
    public static function allItemList () {
        return self::getClass()->allItemList();
    }

    /**
     * 设置调拨单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAllocationName () {
        return self::getClass()->setAllocationName();
    }

    /**
     * 创建调拨单
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationType 单据类型 [ require true ]
     * @support  int $fromStoreId 出仓门店id 
     * @support  int $fromStorageId 出货仓库id 
     * @support  int $toStoreId 收货门店id 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $itemList 调拨单sku列表 
     * @support  string $remark 备注 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量创建调拨单
     *
     * @param  array $data 批量调拨列表，单节点参照单条创建 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data, int $operateId) {
        return self::getClass()->batchCreate([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @support  int $fromStaffId 发货人id [ require true ]
     * @support  string $remark 备注 
     * @support  array $trackingNumbers 物流单号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocationShip (int $operateId) {
        return self::getClass()->allocationShip([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeAllocationItem (int $operateId) {
        return self::getClass()->closeAllocationItem([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量关闭调拨单
     *
     * @support  array $ids 调拨单ids [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeAllocationByIds (int $operateId) {
        return self::getClass()->closeAllocationByIds([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据需求明细IDs获取调拨明细
     *
     * @param  array $demandItemIds 需求itemIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemListByDemandItemIds (array $demandItemIds) {
        return self::getClass()->itemListByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单
     *
     * @param  array $allocationNos 调拨单号allocationNos [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allocationsRetryToEbs (array $allocationNos) {
        return self::getClass()->allocationsRetryToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * 供应链总仓-调拨发货-wms回调
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmSalePlan (array $data) {
        return self::getClass()->confirmSalePlan([
            "data" => $data,
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单-入仓
     *
     * @param  array $receiveIds 收货单号 [Original type array&lt;string&gt;] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveRetryToEbs (array $receiveIds) {
        return self::getClass()->receiveRetryToEbs([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}