<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 */
class PurchaseGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 供应链总仓-调拨发货-wms回调
     *
     * @param  string $startAt start_at [ require true ]
     * @param  string $endAt end_at [ require true ]
     * @param  int $createBy 下单人工号 [Original type uint] [ require true ]
     * @param  string $status 状态 [ require true ]
     * @param  string $type 集采类型:normal/excel [ require true ]
     * @param  string $purchaseType 采购类型 [ require true ]
     * @param  string $demandNo 需求单号 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $startAt, string $endAt, int $createBy, string $status, string $type, string $purchaseType, string $demandNo, int $page, int $pageSize) {
        return self::getClass()->list([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "createBy" => $createBy,
            "status" => $status,
            "type" => $type,
            "purchaseType" => $purchaseType,
            "demandNo" => $demandNo,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}