<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStorageByStoreIdByParams(array $params)
 * @method getStorageByIdByParams(array $params)
 * @method getStorageAddressByIdByParams(array $params)
 * @method getStorageAddressByIdsByParams(array $params)
 * @method getStoragesByIdsByParams(array $params)
 * @method getStorageListByParams(array $params)
 * @method getStoragesByParams(array $params)
 * @method getStoragesBySourceAndUseTypeByParams(array $params)
 * @method getStorageByStoreIdsByParams(array $params)
 * @method createStorageByStoreByParams(array $params)
 * @method createStorageBySupplierByParams(array $params)
 * @method updatedStorageByStoreByParams(array $params)
 * @method storageSyncByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店仓库
     *
     * @support  int $storeId 门店ID 
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId();
    }

    /**
     * 根据id获取仓库信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageById (int $id) {
        return self::getClass()->getStorageById([
            "id" => $id,
        ]);
    }

    /**
     * 根据id获取仓库的地址信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageAddressById (int $id) {
        return self::getClass()->getStorageAddressById([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取仓库的地址信息
     *
     * @param  array $ids 仓库IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageAddressByIds (array $ids) {
        return self::getClass()->getStorageAddressByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据ids获取仓库信息
     *
     * @param  array $ids 仓库ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesByIds (array $ids) {
        return self::getClass()->getStoragesByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @support  int $storeId 门店ID 
     * @support  array $source 仓库归属方 1是总仓，2是门店，3是供应商, 4总部职能 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 
     * @support  string $name 仓库名称 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageList () {
        return self::getClass()->getStorageList();
    }

    /**
     * 获取仓库列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * 根据source和useType获取仓库信息
     *
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [Original type uint] 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesBySourceAndUseType () {
        return self::getClass()->getStoragesBySourceAndUseType();
    }

    /**
     * 获取门店仓库
     *
     * @support  array $storeIds 门店ids 
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreIds () {
        return self::getClass()->getStorageByStoreIds();
    }

    /**
     * 创建自用/零售仓库
     *
     * @param  int $id 门店id [ require true ]
     * @param  string $name 门店名 [ require true ]
     * @param  bool $isAddress 是否更新地址 [ require true ]
     * @param  string $extend 扩展信息 [ require true ]
     * @param  string $source 仓库类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageByStore (int $id, string $name, bool $isAddress = false, string $extend = [], string $source = 2) {
        return self::getClass()->createStorageByStore([
            "id" => $id,
            "name" => $name,
            "isAddress" => $isAddress,
            "extend" => $extend,
            "source" => $source,
        ]);
    }

    /**
     * 创建供应商仓库
     *
     * @param  int $id 供应商id [ require true ]
     * @param  string $name 供应商名 [ require true ]
     * @param  array $extend 供应仓库收货地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageBySupplier (int $id, string $name, array $extend) {
        return self::getClass()->createStorageBySupplier([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 修改门店信息
     *
     * @param  array $original 原始数据 [ require true ]
     * @param  array $attributes 修改后的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatedStorageByStore (array $original, array $attributes) {
        return self::getClass()->updatedStorageByStore([
            "original" => $original,
            "attributes" => $attributes,
        ]);
    }

    /**
     * 用于供应商仓库地址初始化
     *
     * @param  int $storageId 仓库id [ require true ]
     * @param  string $province 省份 [ require true ]
     * @param  string $area 区县 [ require true ]
     * @param  string $address 详细地址 [ require true ]
     * @param  string $userName 收货人 [ require true ]
     * @param  string $phone 联系方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storageSync (int $storageId, string $province = '', string $area = '', string $address = '', string $userName = '', string $phone = '') {
        return self::getClass()->storageSync([
            "storageId" => $storageId,
            "province" => $province,
            "area" => $area,
            "address" => $address,
            "userName" => $userName,
            "phone" => $phone,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}