<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method checkTimeByParams(array $params)
 * @method operationByParams(array $params)
 */
class PurchaseNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购商城配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 是否是需求单时间
     *
     * @support  int $startDay 下单日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTime () {
        return self::getClass()->checkTime();
    }

    /**
     * 创建/修改
     *
     * @support  array $content 公告 
     * @support  array $time 下单日期 
     * @throws  \Exception
     * @return  mixed
     */
    public static function operation () {
        return self::getClass()->operation();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}