<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method checkTimeByParams(array $params)
 * @method operationDateLimitByParams(array $params)
 * @method operationNoticeByParams(array $params)
 */
class PurchaseNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购商城配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo () {
        return self::getClass()->getInfo();
    }

    /**
     * 是否是需求单下单时间
     *
     * @param  int $startDay 下单日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTime (int $startDay) {
        return self::getClass()->checkTime([
            "startDay" => $startDay,
        ]);
    }

    /**
     * 创建/修改 限制时间
     *
     * @support  array $time 下单日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationDateLimit () {
        return self::getClass()->operationDateLimit();
    }

    /**
     * 创建/修改 通知
     *
     * @support  array $content 通知 
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationNotice () {
        return self::getClass()->operationNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}