<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuInfoByKeywordByParams(array $params)
 * @method getSkuInfoByIdsByParams(array $params)
 * @method getSkuListByParams(array $params)
 * @method getSkuListBySkuCodesByParams(array $params)
 * @method getSkuListByPageByParams(array $params)
 * @method editRetailMaterialByParams(array $params)
 * @method editRetailMaterialSkuByParams(array $params)
 * @method getMaterialSkusWithCategoryByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料sku信息
     *
     * @param  int $source 物料来源 [ require true ]
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByKeyword (int $source, string $keyword) {
        return self::getClass()->getSkuInfoByKeyword([
            "source" => $source,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 根据物料skuId获取物料信息
     *
     * @param  array $skuIds 物料skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByIds (array $skuIds) {
        return self::getClass()->getSkuInfoByIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 根据条件获取物料信息
     *
     * @support  array $skuIds 物料skuIds 
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuList () {
        return self::getClass()->getSkuList();
    }

    /**
     * 根据条件获取物料信息
     *
     * @support  array $skuCodes 物料SkuCodes 
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuListBySkuCodes () {
        return self::getClass()->getSkuListBySkuCodes();
    }

    /**
     * 分页获取物料信息
     *
     * @support  array $skuIds 物料skuIds 
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuListByPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSkuListByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 同步零售产品到物料
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editRetailMaterial (array $data, int $operateId) {
        return self::getClass()->editRetailMaterial([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 同步零售产品sku到物料sku
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editRetailMaterialSku (array $data, int $operateId) {
        return self::getClass()->editRetailMaterialSku([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     *
     * @support  int $source 物料来源 1是物料（自用）2 商品（零售） 
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialSkusWithCategory (int $page, int $pageSize) {
        return self::getClass()->getMaterialSkusWithCategory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建物料
     *
     * @param  int $createBy createBy [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  int $isStockTaking 是否盘点 [Original type uint] 
     * @support  int $isFixedAsset 是否资产 [Original type uint] 
     * @support  int $fixedAssetType 资产类型 [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $createBy) {
        return self::getClass()->create([
            "createBy" => $createBy,
        ]);
    }

    /**
     * 更新物料
     *
     * @param  int $updateBy updateBy [Original type uint] [ require true ]
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeType 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  int $isStockTaking 是否盘点 [Original type uint] 
     * @support  int $isFixedAsset 是否资产 [Original type uint] 
     * @support  int $fixedAssetType 资产类型 [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $updateBy) {
        return self::getClass()->update([
            "id" => $id,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 
     * @support  string $code code 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}