<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByPageByParams(array $params)
 * @method operationByParams(array $params)
 * @method batchOperationByParams(array $params)
 * @method getInfoByIdByParams(array $params)
 */
class PurchaseCountLimit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分页数据
     *
     * @support  int $skuId sku_id 
     * @support  int $sourceId 门店id 
     * @support  int $count 限制条数 
     * @support  int $createBy 操作人 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listByPage (int $page = 0, int $pageSize = 10) {
        return self::getClass()->listByPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 操作
     *
     * @support  int $skuId sku_id 
     * @support  int $storeId 门店id 
     * @support  int $count 限制条数 
     * @support  int $createBy 操作人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function operation () {
        return self::getClass()->operation();
    }

    /**
     * 操作
     *
     * @support  int $createBy 操作人 [ require true ]
     * @support  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchOperation () {
        return self::getClass()->batchOperation();
    }

    /**
     * 根据id获取详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoById (int $id) {
        return self::getClass()->getInfoById([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseCountLimit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}