<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStorageByStoreIdByParams(array $params)
 * @method getStorageByIdByParams(array $params)
 * @method getStoragesByIdsByParams(array $params)
 * @method getStorageListByParams(array $params)
 * @method getStoragesByParams(array $params)
 * @method getStoragesBySourceAndUseTypeByParams(array $params)
 * @method getStorageByStoreIdsByParams(array $params)
 * @method createStorageByStoreByParams(array $params)
 * @method createStorageBySupplierByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店仓库
     *
     * @support  int $storeId 门店ID 
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId();
    }

    /**
     * 根据id获取仓库信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageById (int $id) {
        return self::getClass()->getStorageById([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取仓库信息
     *
     * @param  array $ids 仓库ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesByIds (array $ids) {
        return self::getClass()->getStoragesByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @support  int $storeId 门店ID 
     * @support  array $source 仓库归属方 1是总仓，2是门店，3是供应商, 4总部职能 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 
     * @support  string $name 仓库名称 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageList () {
        return self::getClass()->getStorageList();
    }

    /**
     * 获取仓库列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * 根据source和useType获取仓库信息
     *
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [Original type uint] 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesBySourceAndUseType () {
        return self::getClass()->getStoragesBySourceAndUseType();
    }

    /**
     * 获取门店仓库
     *
     * @support  array $storeIds 门店ids 
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreIds () {
        return self::getClass()->getStorageByStoreIds();
    }

    /**
     * 创建门店仓库
     *
     * @param  int $id 门店id [ require true ]
     * @param  string $name 门店名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageByStore (int $id, string $name) {
        return self::getClass()->createStorageByStore([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 创建供应商仓库
     *
     * @param  int $id 供应商id [ require true ]
     * @param  string $name 供应商名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStorageBySupplier (int $id, string $name) {
        return self::getClass()->createStorageBySupplier([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}