<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuInfoByKeywordByParams(array $params)
 * @method getSkuInfoByIdsByParams(array $params)
 * @method editRetailMaterialByParams(array $params)
 * @method editRetailMaterialSkuByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料sku信息
     *
     * @param  int $source 物料来源 [ require true ]
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByKeyword (int $source, string $keyword) {
        return self::getClass()->getSkuInfoByKeyword([
            "source" => $source,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 根据物料skuId获取物料信息
     *
     * @param  array $skuIds 物料skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuInfoByIds (array $skuIds) {
        return self::getClass()->getSkuInfoByIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 同步零售产品到物料
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editRetailMaterial (array $data, int $operateId) {
        return self::getClass()->editRetailMaterial([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 同步零售产品sku到物料sku
     *
     * @param  array $data 物料信息 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editRetailMaterialSku (array $data, int $operateId) {
        return self::getClass()->editRetailMaterialSku([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}