<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStorageByStoreIdByParams(array $params)
 * @method getStorageByIdByParams(array $params)
 * @method getStoragesByIdsByParams(array $params)
 * @method getStorageListByParams(array $params)
 * @method getStoragesByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店仓库
     *
     * @support  int $storeId 门店ID 
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId();
    }

    /**
     * 根据id获取仓库信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageById (int $id) {
        return self::getClass()->getStorageById([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取仓库信息
     *
     * @param  array $ids 仓库ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesByIds (array $ids) {
        return self::getClass()->getStoragesByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @support  int $storeId 门店ID 
     * @support  array $source 仓库归属方 1是总部，2是门店，3是供应商 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageList () {
        return self::getClass()->getStorageList();
    }

    /**
     * 获取门店仓库列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}