<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setStockOutNameByParams(array $params)
 * @method setStockInNameByParams(array $params)
 * @method stockFlowListByParams(array $params)
 * @method stockFlowItemListByParams(array $params)
 * @method stockFlowDetailByParams(array $params)
 * @method stockListByParams(array $params)
 * @method stockListBySkuIdsByParams(array $params)
 * @method stockInsideMoveByParams(array $params)
 * @method stockOtherOutByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置出库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockOutName () {
        return self::getClass()->setStockOutName();
    }

    /**
     * 设置入库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockInName () {
        return self::getClass()->setStockInName();
    }

    /**
     * 出入库记录列表
     *
     * @support  int $storageId 收货仓库id [ require true ]
     * @support  string $documentType 单据类型 
     * @support  string $associateDocumentNo 上级单据编号 
     * @support  string $createAtBegin 创建开始时间 
     * @support  string $createAtEnd 创建结束时间 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockFlowList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 出入库记录明细列表
     *
     * @support  int $storageId 收货仓库id [ require true ]
     * @support  int $skuId 收货仓库id [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowItemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockFlowItemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 出入库记录详情
     *
     * @param  int $id 出入库详情id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowDetail (int $id) {
        return self::getClass()->stockFlowDetail([
            "id" => $id,
        ]);
    }

    /**
     * 库存列表
     *
     * @support  int $storageId 仓库id [ require true ]
     * @support  string $skuName sku名称 
     * @support  string $skuCode SKU编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->stockList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据仓库id获取对应skuIds的库存
     *
     * @param  int $storageId 仓库id [ require true ]
     * @param  array $skuIds sku列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockListBySkuIds (int $storageId, array $skuIds) {
        return self::getClass()->stockListBySkuIds([
            "storageId" => $storageId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 仓内库存转移
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  string $fromCount 仓内调出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  string $toCount 仓内调入库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  string $remark 备注 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockInsideMove (int $operateId) {
        return self::getClass()->stockInsideMove([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 其他出库
     *
     * @support  int $storageId 调整仓库id [ require true ]
     * @support  string $fromType 出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  int $memberId 自用物料领用人 
     * @support  string $receiver 其他出库收货人 
     * @support  string $remark 备注 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function stockOtherOut (int $operateId) {
        return self::getClass()->stockOtherOut([
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}