<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setReceiveKeyNameByParams(array $params)
 * @method addReceiveLogisticByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method allItemListByParams(array $params)
 * @method receiveShipByParams(array $params)
 * @method exceptionListByParams(array $params)
 * @method handleExceptionByFromByParams(array $params)
 * @method handleExceptionByToByParams(array $params)
 * @method closeByParams(array $params)
 * @method receiveByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemByOrderItemIdsByParams(array $params)
 * @method exceptionStateByParams(array $params)
 */
class Receive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置收货单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setReceiveKeyName () {
        return self::getClass()->setReceiveKeyName();
    }

    /**
     * 新增发货单物流
     *
     * @param  int $receiveId 发货单id [ require true ]
     * @param  array $trackingNumbers 物流单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceiveLogistic (int $receiveId, array $trackingNumbers) {
        return self::getClass()->addReceiveLogistic([
            "receiveId" => $receiveId,
            "trackingNumbers" => $trackingNumbers,
        ]);
    }

    /**
     * 收货列表
     *
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  string $receiveNo 收货单号 
     * @support  int $fromStorageId 发货仓库id 
     * @support  string $trackingNumber 物流单号 
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 
     * @support  string $skuName sku名称 
     * @support  string $skuCode sku编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取发货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 发货单子单据列表
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发货单子单据列表
     *
     * @support  int $id 发货单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @throws  \Exception
     * @return  array
     */
    public static function allItemList () {
        return self::getClass()->allItemList();
    }

    /**
     * 收货
     *
     * @param  int $id 发货单id [ require true ]
     * @param  array $itemList 发货单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $toMemberId 收货人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveShip (int $id, array $itemList, int $operateId, int $toMemberId) {
        return self::getClass()->receiveShip([
            "id" => $id,
            "itemList" => $itemList,
            "operateId" => $operateId,
            "toMemberId" => $toMemberId,
        ]);
    }

    /**
     * 收货异常列表
     *
     * @support  int $fromStorageId 发货仓库id 
     * @support  int $toStorageId 收货仓库id 
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 
     * @support  string $receiveNo 收货单号 
     * @support  int $status 状态 1提交，2处理完成 
     * @support  string $skuName sku名字 
     * @support  int $handler 异常处理人 1是发货方 2是总部 [ require true ]
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function exceptionList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->exceptionList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 异常归属发货方处理逻辑
     *
     * @param  int $receiveItemId 发货单明细id [ require true ]
     * @param  int $skuId skuId [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $errorNum 异常处理数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleExceptionByFrom (int $receiveItemId, int $skuId, int $operateId, int $errorNum) {
        return self::getClass()->handleExceptionByFrom([
            "receiveItemId" => $receiveItemId,
            "skuId" => $skuId,
            "operateId" => $operateId,
            "errorNum" => $errorNum,
        ]);
    }

    /**
     * 异常归属收货方处理逻辑
     *
     * @param  int $receiveItemId 发货单明细id [ require true ]
     * @param  int $skuId skuId [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  int $errorNum 异常处理数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleExceptionByTo (int $receiveItemId, int $skuId, int $operateId, int $errorNum) {
        return self::getClass()->handleExceptionByTo([
            "receiveItemId" => $receiveItemId,
            "skuId" => $skuId,
            "operateId" => $operateId,
            "errorNum" => $errorNum,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $updateBy 修改人工号 [Original type uint] [ require true ]
     * @param  int $receiveId 收货单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $updateBy, int $receiveId) {
        return self::getClass()->close([
            "updateBy" => $updateBy,
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 批量收货
     *
     * @param  int $updateBy 修改人工号 [Original type uint] [ require true ]
     * @param  array $data 收货单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receive (int $updateBy, array $data) {
        return self::getClass()->receive([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 根据采购单明细ids获取收货明细信息
     *
     * @param  array $orderItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getItemByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * 异常申述（处理人变更）
     *
     * @param  int $id 异常id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exceptionState (int $id, int $operateId) {
        return self::getClass()->exceptionState([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Receive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Receive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}