<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addReceiveLogisticByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 */
class Receive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增发货单物流
     *
     * @param  int $receiveId 发货单id [ require true ]
     * @param  string $trackingNumber 物流单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceiveLogistic (int $receiveId, string $trackingNumber) {
        return self::getClass()->addReceiveLogistic([
            "receiveId" => $receiveId,
            "trackingNumber" => $trackingNumber,
        ]);
    }

    /**
     * 收货列表列表
     *
     * @support  int $toStorageId 收货仓库id [ require true ]
     * @support  string $receiveNo 调拨单号 
     * @support  int $fromStorageId 发货仓库id 
     * @support  string $trackingNumber 物流单号 
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 
     * @support  string $skuName sku名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取发货单详情
     *
     * @param  int $id 发货单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Receive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Receive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}