<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-10 15:59:04
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Supplier
 * @method getListPageByParams(array $params) getListPage
 * @method getAccountListByParams(array $params) getAccountList
 * @method editSupplierInfoByParams(array $params) editSupplierInfo
 * @method createAccountByParams(array $params) createAccount
 * @method delAccountByParams(array $params) delAccount
 * @method getSuppliersByParams(array $params) 通过名字或者供应商id得到供应商
 * @method findOrFailByIdByParams(array $params) 通过供应商id得到供应商
 * @method syncSupplierByParams(array $params) 同步供应商
 * @method getSuppliersByIdsByParams(array $params) 通过供应商id得到供应商s
 * @method syncJdSupplierByParams(array $params) 同步金蝶供应商
 * @method searchSupplierAccountByParams(array $params) 供应商账户查询
 * @method getSupplyMapByParams(array $params) 获取供应商账户map
 * @method getAllSupplyStorageIdsByParams(array $params) 获取开启供应商的仓库列表
 * @method setSyncWmsByParams(array $params) 新增设置供应商对接巨沃
 * @method endSyncWmsByParams(array $params) 关闭供应商对接巨沃
 * @method getWmsCodeByParams(array $params) 获取巨沃仓信息
 */
class Supplier {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Supplier";

    /**
     * getListPage
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPage(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * getAccountList
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAccountList (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAccountList(["supplierId" => $supplierId]);
    }

    /**
     * editSupplierInfo
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editSupplierInfo (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSupplierInfo(["supplierId" => $supplierId]);
    }

    /**
     * createAccount
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createAccount (int $supplierId, string $phone, string $nickName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAccount(["supplierId" => $supplierId, "phone" => $phone, "nickName" => $nickName]);
    }

    /**
     * delAccount
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delAccount (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delAccount(["id" => $id]);
    }

    /**
     * 通过名字或者供应商id得到供应商
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSuppliers () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSuppliers([]);
    }

    /**
     * 通过供应商id得到供应商
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function findOrFailById (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findOrFailById(["supplierId" => $supplierId]);
    }

    /**
     * 同步供应商
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function syncSupplier () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncSupplier([]);
    }

    /**
     * 通过供应商id得到供应商s
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSuppliersByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSuppliersByIds(["ids" => $ids]);
    }

    /**
     * 同步金蝶供应商
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function syncJdSupplier () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncJdSupplier([]);
    }

    /**
     * 供应商账户查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchSupplierAccount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchSupplierAccount([]);
    }

    /**
     * 获取供应商账户map
     * @return  array
    */
    public static function getSupplyMap () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyMap();
    }

    /**
     * 获取开启供应商的仓库列表
     * @return  array
    */
    public static function getAllSupplyStorageIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSupplyStorageIds();
    }

    /**
     * 新增设置供应商对接巨沃
     * @return  bool
    */
    public static function setSyncWms (\Mainto\Bridge\Structs\HimoSupplyChain\WmsStorageCode\Cmd\WmsStorageCodeCmd $wmsStorageCodeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setSyncWms($wmsStorageCodeCmd);
    }

    /**
     * 关闭供应商对接巨沃
     * @return  bool
    */
    public static function endSyncWms (\Mainto\Bridge\Structs\HimoSupplyChain\WmsStorageCode\Cmd\EndWmsStorageCodeCmd $endWmsStorageCodeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->endSyncWms($endWmsStorageCodeCmd);
    }

    /**
     * 获取巨沃仓信息
     * @return  array
    */
    public static function getWmsCode (\Mainto\Bridge\Structs\HimoSupplyChain\WmsStorageCode\Cmd\SearchWmsStorageCodeCmd $searchWmsStorageCodeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWmsCode($searchWmsStorageCodeCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}