<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-10 15:59:04
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseReturn
 * @method createReturnByParams(array $params) 创建退货单
 * @method updateReturnByParams(array $params) 更新退货单
 * @method approvalRevokeByParams(array $params) 审批单撤回
 * @method updateStatusByParams(array $params) 更新状态
 * @method getDetailByParams(array $params) 获取退货单子单(退货单主单详情）
 * @method getCreatInfoByParams(array $params) 创建时获取明细
 * @method getListPaginationByParams(array $params) 分页查询退货单列表
 * @method getListByParams(array $params) 退货单列表不分页
 * @method getReturnItemCountByParams(array $params) 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
 * @method retryReturnEbsByParams(array $params) ebs重推
 * @method dingCallBackByParams(array $params) 退回单审批回调
 */
class PurchaseReturn {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "PurchaseReturn";

    /**
     * 创建退货单
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
    */
    public static function createReturn (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $purchaseReturnCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createReturn($purchaseReturnCreateCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }

    /**
     * 更新退货单
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
    */
    public static function updateReturn (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnUpdateCMD $purchaseReturnUpdateCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateReturn($purchaseReturnUpdateCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }

    /**
     * 审批单撤回
     * @return  bool
    */
    public static function approvalRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnApprovalRevokeCMD $purchaseReturnApprovalRevokeCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approvalRevoke($purchaseReturnApprovalRevokeCMD);
    }

    /**
     * 更新状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateStatus (int $returnId, string $status, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["returnId" => $returnId, "status" => $status, "updateBy" => $updateBy]);
    }

    /**
     * 获取退货单子单(退货单主单详情）
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
    */
    public static function getDetail (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnDetailQuery $returnDetailQuery) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDetail($returnDetailQuery),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }

    /**
     * 创建时获取明细
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnCreateInfoDTO
    */
    public static function getCreatInfo (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnCreateInfoQuery $returnCreateInfoQuery) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCreatInfo($returnCreateInfoQuery),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnCreateInfoDTO"
        );
    }

    /**
     * 分页查询退货单列表
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnPageDTO
    */
    public static function getListPagination (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $purchaseReturnPageQuery) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getListPagination($purchaseReturnPageQuery),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnPageDTO"
        );
    }

    /**
     * 退货单列表不分页
     * @return  array
    */
    public static function getList (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $purchaseReturnPageQuery) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getList($purchaseReturnPageQuery),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnListDTO[]"
        );
    }

    /**
     * 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getReturnItemCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReturnItemCount([]);
    }

    /**
     * ebs重推
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function retryReturnEbs () {
        return RpcClass::getClass(self::$serviceName, self::$className)->retryReturnEbs([]);
    }

    /**
     * 退回单审批回调
     * @return  string
    */
    public static function dingCallBack () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingCallBack();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}