<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-02 18:14:07
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseShipNotice
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 详情
 * @method itemListByParams(array $params) 明细列表
 * @method importByParams(array $params) 导入快递单号和数量
 * @method importTrackingNumberByParams(array $params) 导入快递单号
 * @method batchSendByParams(array $params) 批量发运
 * @method sendByParams(array $params) 发运
 * @method batchUpdateByParams(array $params) 批量更新
 * @method batchCloseByParams(array $params) 批量关闭
 * @method getCreateByInfosByParams(array $params) 获取创建人s
 * @method getItemsByOrderItemIdsByParams(array $params) 根据订单明细ids获取发货明细信息
 * @method getItemsByDemandItemIdsByParams(array $params) 根据订单明细ids获取发货明细信息
 * @method getItemsByItemIdsByParams(array $params) 根据订单明细ids获取发货明细信息
 * @method getByIdsByParams(array $params) 根据发货ids获取发货信息
 * @method getItemsByStatusAndNoticeIdsByParams(array $params) 根据发货ids获取发货信息
 * @method getItemsByNoticeIdsByParams(array $params) 根据发货单IDs获取明细
 * @method trySyncReceiveToWmsByParams(array $params) trySyncReceiveToWms
 * @method searchShipNoticeByParams(array $params) 查询发货通知单
 * @method changePlanShipDateByParams(array $params) 发货通知单更改预计到货时间-发货时间
 * @method checkBmsShipByParams(array $params) checkBmsShip
 * @method checkBmsNoticeItemIdsByParams(array $params) checkBmsNoticeItemIds
 * @method batchSendItemsByParams(array $params) 批量发运接口更新,不合单。一个主单对应一个子单
 * @method getRedPointCountByStorageIdByParams(array $params) 获取同一个发货通知单仓库下红点数量
 * @method searchSupplyShipNoticeItemsByParams(array $params) 查询供应商协同发货通知单
 * @method getShopCountByStorageIdByParams(array $params) 获取同一个发货通知单仓库下门店数
 * @method pushToWmsByParams(array $params) pushToWms
 */
class PurchaseShipNotice {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "PurchaseShipNotice";

    /**
     * 列表
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticePaginateDTO
    */
    public static function list (?\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $shipNoticeSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($shipNoticeSearchCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticePaginateDTO"
        );
    }

    /**
     * 详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail([]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO"
        );
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 导入快递单号和数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function import (int $updateBy, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->import(["updateBy" => $updateBy, "data" => $data]);
    }

    /**
     * 导入快递单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function importTrackingNumber (int $updateBy, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->importTrackingNumber(["updateBy" => $updateBy, "data" => $data]);
    }

    /**
     * 批量发运
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchSend (int $createBy, array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSend(["createBy" => $createBy, "noticeIds" => $noticeIds]);
    }

    /**
     * 发运
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function send (int $createBy, int $noticeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->send(["createBy" => $createBy, "noticeId" => $noticeId]);
    }

    /**
     * 批量更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchUpdate (int $updateBy, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdate(["updateBy" => $updateBy, "data" => $data]);
    }

    /**
     * 批量关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchClose (int $updateBy, array $data, bool $check = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["updateBy" => $updateBy, "data" => $data, "check" => $check]);
    }

    /**
     * 获取创建人s
     * @return  array
    */
    public static function getCreateByInfos () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCreateByInfos();
    }

    /**
     * 根据订单明细ids获取发货明细信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByOrderItemIds (array $orderItemIds, string $type = 'purchase', int $withShip = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByOrderItemIds(["orderItemIds" => $orderItemIds, "type" => $type, "withShip" => $withShip]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByDemandItemIds (array $demandItemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByDemandItemIds(["demandItemIds" => $demandItemIds]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByItemIds (array $itemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByItemIds(["itemIds" => $itemIds]);
    }

    /**
     * 根据发货ids获取发货信息
     * @return  array
    */
    public static function getByIds (?\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSearchCMD $shipNoticeItemSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getByIds($shipNoticeItemSearchCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]"
        );
    }

    /**
     * 根据发货ids获取发货信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByStatusAndNoticeIds (array $status, array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByStatusAndNoticeIds(["status" => $status, "noticeIds" => $noticeIds]);
    }

    /**
     * 根据发货单IDs获取明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByNoticeIds (array $noticeIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getItemsByNoticeIds(["noticeIds" => $noticeIds]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeItemDTO[]"
        );
    }

    /**
     * trySyncReceiveToWms
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function trySyncReceiveToWms (array $receiveIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->trySyncReceiveToWms(["receiveIds" => $receiveIds]);
    }

    /**
     * 查询发货通知单
     * @return  array
    */
    public static function searchShipNotice (?\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $shipNoticeSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchShipNotice($shipNoticeSearchCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]"
        );
    }

    /**
     * 发货通知单更改预计到货时间-发货时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changePlanShipDate (array $noticeIds, string $arriveDate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePlanShipDate(["noticeIds" => $noticeIds, "arriveDate" => $arriveDate]);
    }

    /**
     * checkBmsShip
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkBmsShip () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkBmsShip([]);
    }

    /**
     * checkBmsNoticeItemIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkBmsNoticeItemIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkBmsNoticeItemIds([]);
    }

    /**
     * 批量发运接口更新,不合单。一个主单对应一个子单
     * @return  array
    */
    public static function batchSendItems (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSendCMD $shipNoticeItemSendCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSendItems($shipNoticeItemSendCMD);
    }

    /**
     * 获取同一个发货通知单仓库下红点数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function getRedPointCountByStorageId (array $storageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRedPointCountByStorageId(["storageIds" => $storageIds]);
    }

    /**
     * 查询供应商协同发货通知单
     * @return  array
    */
    public static function searchSupplyShipNoticeItems (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\SupplyShipNoticeItemSearchCMD $supplyShipNoticeItemSearchCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchSupplyShipNoticeItems($supplyShipNoticeItemSearchCMD);
    }

    /**
     * 获取同一个发货通知单仓库下门店数
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getShopCountByStorageId (array $storageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopCountByStorageId(["storageIds" => $storageIds]);
    }

    /**
     * pushToWms
     * @return  array
    */
    public static function pushToWms (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\PushToWMSCMD $pushToWMSCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushToWms($pushToWMSCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}