<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-04 18:41:27
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Restock
 * @method restockSubmitByParams(array $params) 提交补货单
 * @method detailByParams(array $params) 补货单详情
 * @method demandSyncByParams(array $params) 重试创建需求单
 */
class Restock {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Restock";

    /**
     * 提交补货单
     * @return  array
    */
    public static function restockSubmit (\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSaveCMD $restockSaveCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->restockSubmit($restockSaveCMD);
    }

    /**
     * 补货单详情
     * @return  mixed
    */
    public static function detail (\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSearchCMD $restockSearchCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail($restockSearchCMD);
    }

    /**
     * 重试创建需求单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function demandSync (int $scrapId, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->demandSync(["scrapId" => $scrapId, "status" => $status]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}