<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-04 18:41:27
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MaterialSku
 * @method getMaterialSkusByParams(array $params) 得到物料skus
 * @method getByIdsWithMaterialByParams(array $params) 得到物料skus
 * @method getMaterialSkuIdsBySupplierIdByParams(array $params) 通过供应商id得到物料skuIds
 * @method getSkuIdsByParams(array $params) 通过供应商id得到物料skuIds
 * @method getMaterialSkuByBuyerByParams(array $params) 通过购买者id得到供应商id列表
 * @method getMaterialSkuIdsByParams(array $params) 得到物料skuIds
 * @method getMaterialIdsBySupplierIdByParams(array $params) 通过供应商id得到物料id列表
 * @method getOneByParams(array $params) 得到一个物料sku
 * @method getBaseInfoBySkuNameByParams(array $params) 得到物料基本信息
 * @method getMaterialSkuByBuyerIdByParams(array $params) 通过员工id得到物料sku
 * @method getMaterialIdsByIdsByParams(array $params) 通过skuIds得到物料ids
 * @method getMaterialSkuByIdsByParams(array $params) 通过skuIds得到物料ids
 * @method getSkusByMaterialIdByParams(array $params) 通过物料ID和状态获取SKU
 * @method getMaterialSkuListByParams(array $params) 通过物料ID和状态获取SKU
 * @method getInfoByParams(array $params) 获取指定物料ids且指定状态的sku 可指定字段 默认只返回id
 * @method getInfoBySkuCodeByParams(array $params) 通过sku_code 获取物料信息
 * @method getMaterialIdsByCategoryIdByParams(array $params) 通过分类id得到物料
 * @method getMaterialSkuPageniteByParams(array $params) getMaterialSkuPagenite
 * @method getSupplySystemSkuListPageByParams(array $params) getSupplySystemSkuListPage
 * @method skuByCodeOrBarcodeByParams(array $params) 获取sku code or barcode
 * @method getSkuLiveListByParams(array $params) 通过仓库id+skuIds获取物料使用生命周期
 */
class MaterialSku {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "MaterialSku";

    /**
     * 得到物料skus
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkus (array $ids, string $status = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkus(["ids" => $ids, "status" => $status]);
    }

    /**
     * 得到物料skus
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getByIdsWithMaterial (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByIdsWithMaterial(["ids" => $ids]);
    }

    /**
     * 通过供应商id得到物料skuIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialSkuIdsBySupplierId (int $supplierId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuIdsBySupplierId(["supplierId" => $supplierId]);
    }

    /**
     * 通过供应商id得到物料skuIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIds([]);
    }

    /**
     * 通过购买者id得到供应商id列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialSkuByBuyer (int $buyerId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuByBuyer(["buyerId" => $buyerId]);
    }

    /**
     * 得到物料skuIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkuIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuIds([]);
    }

    /**
     * 通过供应商id得到物料id列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialIdsBySupplierId (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialIdsBySupplierId(["supplierId" => $supplierId]);
    }

    /**
     * 得到一个物料sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOne (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOne(["data" => $data]);
    }

    /**
     * 得到物料基本信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBaseInfoBySkuName (bool $isExcel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseInfoBySkuName(["isExcel" => $isExcel]);
    }

    /**
     * 通过员工id得到物料sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkuByBuyerId (int $loginStaffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuByBuyerId(["loginStaffId" => $loginStaffId]);
    }

    /**
     * 通过skuIds得到物料ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialIdsByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialIdsByIds(["ids" => $ids]);
    }

    /**
     * 通过skuIds得到物料ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialSkuByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuByIds(["ids" => $ids]);
    }

    /**
     * 通过物料ID和状态获取SKU
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkusByMaterialId (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByMaterialId(["id" => $id, "status" => $status]);
    }

    /**
     * 通过物料ID和状态获取SKU
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialSkuList (array $source, array $params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuList(["source" => $source, "params" => $params]);
    }

    /**
     * 获取指定物料ids且指定状态的sku 可指定字段 默认只返回id
     * @return  array
    */
    public static function getInfo (?\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\MaterialQueryCMD $materialQueryCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo($materialQueryCMD);
    }

    /**
     * 通过sku_code 获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getInfoBySkuCode () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfoBySkuCode([]);
    }

    /**
     * 通过分类id得到物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialIdsByCategoryId (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialIdsByCategoryId(["categoryId" => $categoryId]);
    }

    /**
     * getMaterialSkuPagenite
     * @return  array
    */
    public static function getMaterialSkuPagenite (?\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\MaterialQueryCMD $materialQueryCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkuPagenite($materialQueryCMD);
    }

    /**
     * getSupplySystemSkuListPage
     * @return  array
    */
    public static function getSupplySystemSkuListPage (?\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\MaterialQueryCMD $materialQueryCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplySystemSkuListPage($materialQueryCMD);
    }

    /**
     * 获取sku code or barcode
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function skuByCodeOrBarcode (string $skuOrBarcode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuByCodeOrBarcode(["skuOrBarcode" => $skuOrBarcode]);
    }

    /**
     * 通过仓库id+skuIds获取物料使用生命周期
     * @return  array
    */
    public static function getSkuLiveList (?\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\MaterialSkuLiveListCMD $materialSkuLiveListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuLiveList($materialSkuLiveListCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}