<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:37:19
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class TransformInfo
 * @method getProductSkuTransformByParams(array $params) 获取成品下的半成品配方list
 * @method getProductSkuTransformDetailByParams(array $params) 获取成品下的半成品配方详first
 * @method getProductSkuPageListByParams(array $params) 成品boom
 * @method getRawSkuListByParams(array $params) 通过半成品查询配方
 * @method setProductSkuTransformInfoByParams(array $params) 设置成品配方
 * @method batchSetProductSkuTransformInfoByParams(array $params) 批量设置配方
 */
class TransformInfo {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "TransformInfo";

    /**
     * 获取成品下的半成品配方list
     * @return  array
    */
    public static function getProductSkuTransform (\Mainto\Bridge\Structs\HimoSupplyChain\Base\CMD\IdsCmd $idsCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuTransform($idsCmd);
    }

    /**
     * 获取成品下的半成品配方详first
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductSkuTransformDetail (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuTransformDetail(["productSkuId" => $productSkuId]);
    }

    /**
     * 成品boom
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO
    */
    public static function getProductSkuPageList (\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $productSkuPageListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuPageList($productSkuPageListCmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO"
        );
    }

    /**
     * 通过半成品查询配方
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRawSkuList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRawSkuList([]);
    }

    /**
     * 设置成品配方
     * @return  bool
    */
    public static function setProductSkuTransformInfo (\Mainto\Bridge\Structs\HimoSupplyChain\TransformInfo\Cmd\TransformInfoCreateCmd $transformInfoCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductSkuTransformInfo($transformInfoCreateCmd);
    }

    /**
     * 批量设置配方
     * @return  bool
    */
    public static function batchSetProductSkuTransformInfo (\Mainto\Bridge\Structs\HimoSupplyChain\TransformInfo\Cmd\TransformInfoBatchCreateCmd $transformInfoBatchCreateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSetProductSkuTransformInfo($transformInfoBatchCreateCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}