<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:37:19
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Stock
 * @method stockListBySkuIdsByParams(array $params) 根据仓库id获取对应skuIds的库存
 * @method saleChangeStockByParams(array $params) 变更库存，目前只用于销售出库、退货入库
 * @method storageStockByParams(array $params) 获取仓库里的skuids,可指定sku_id
 * @method storageStockBySkuIdByParams(array $params) 获取仓库里的skuid的库存信息
 * @method stockListByParams(array $params) 库存列表--仓库视角 （导出页面仍在使用）
 * @method materialStockListByParams(array $params) 库存列表--商品视角 （导出页面仍在使用
 * @method searchStockByParams(array $params) 库存查询 供应商协同导出
 */
class Stock {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Stock";

    /**
     * 根据仓库id获取对应skuIds的库存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockListBySkuIds (int $storageId, array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockListBySkuIds(["storageId" => $storageId, "skuIds" => $skuIds]);
    }

    /**
     * 变更库存，目前只用于销售出库、退货入库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function saleChangeStock (int $operateId, int $storageId, array $itemList, string $documentType, int $associateDocumentId, string $associateDocumentNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saleChangeStock(["operateId" => $operateId, "storageId" => $storageId, "itemList" => $itemList, "documentType" => $documentType, "associateDocumentId" => $associateDocumentId, "associateDocumentNo" => $associateDocumentNo]);
    }

    /**
     * 获取仓库里的skuids,可指定sku_id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storageStock () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storageStock([]);
    }

    /**
     * 获取仓库里的skuid的库存信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storageStockBySkuId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->storageStockBySkuId([]);
    }

    /**
     * 库存列表--仓库视角 （导出页面仍在使用）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function stockList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stockList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 库存列表--商品视角 （导出页面仍在使用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function materialStockList (int $page = 1, int $pageSize = 10, int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->materialStockList(["page" => $page, "pageSize" => $pageSize, "source" => $source]);
    }

    /**
     * 库存查询 供应商协同导出
     * @return  array
    */
    public static function searchStock () {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStock();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}