<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-06 19:14:56
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Scrap
 * @method listByParams(array $params) 门店报废单列表
 * @method detailByParams(array $params) 报废单详情
 * @method saveByParams(array $params) 提交报废单
 * @method getScrapItemsSortByCategoryByParams(array $params) 分类排序返回报废数据
 * @method missionListByParams(array $params) 报废任务列表
 * @method missionDetailByParams(array $params) 报废任务详情
 * @method missionsDetailByParams(array $params) 获取指定报废任务ids的详情
 * @method missionCreateByParams(array $params) 新增报废任务
 * @method missionRevokeByParams(array $params) 盘点任务撤回
 * @method missionProcessByParams(array $params) 报废进度
 * @method missionProcessRateByParams(array $params) 报废进度计算
 * @method storeInMissionByParams(array $params) 报废任务关联门店
 * @method skuInMissionsByParams(array $params) 报废任务关联sku
 * @method storeDealScrapByParams(array $params) 门店待处理报废单数量
 * @method itemAllListByParams(array $params) 所有报废明细
 * @method dingCallBackByParams(array $params) 报废审批回调
 */
class Scrap {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Scrap";

    /**
     * 门店报废单列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapListCMD $scrapListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($scrapListCMD);
    }

    /**
     * 报废单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }

    /**
     * 提交报废单
     * @return  array
    */
    public static function save (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapSaveCMD $scrapSaveCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save($scrapSaveCMD);
    }

    /**
     * 分类排序返回报废数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getScrapItemsSortByCategory (int $scrapId, bool $isPaginate = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScrapItemsSortByCategory(["scrapId" => $scrapId, "isPaginate" => $isPaginate]);
    }

    /**
     * 报废任务列表
     * @return  array
    */
    public static function missionList (?\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionListCMD $scrapMissionListCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionList($scrapMissionListCMD);
    }

    /**
     * 报废任务详情
     * @return  array
    */
    public static function missionDetail (?\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $scrapMissionDetailCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionDetail($scrapMissionDetailCMD);
    }

    /**
     * 获取指定报废任务ids的详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function missionsDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionsDetail([]);
    }

    /**
     * 新增报废任务
     * @return  bool
    */
    public static function missionCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $scrapMissionCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionCreate($scrapMissionCreateCMD);
    }

    /**
     * 盘点任务撤回
     * @return  bool
    */
    public static function missionRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $scrapMissionRevokeCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionRevoke($scrapMissionRevokeCMD);
    }

    /**
     * 报废进度
     * @return  array
    */
    public static function missionProcess (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $scrapMissionProcessCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionProcess($scrapMissionProcessCMD);
    }

    /**
     * 报废进度计算
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function missionProcessRate (int $missionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionProcessRate(["missionId" => $missionId]);
    }

    /**
     * 报废任务关联门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function storeInMission (int $missionId, bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeInMission(["missionId" => $missionId, "includeDelete" => $includeDelete]);
    }

    /**
     * 报废任务关联sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function skuInMissions (array $missionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuInMissions(["missionIds" => $missionIds]);
    }

    /**
     * 门店待处理报废单数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function storeDealScrap (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeDealScrap(["storeId" => $storeId]);
    }

    /**
     * 所有报废明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemAllList (array $scrapIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemAllList(["scrapIds" => $scrapIds]);
    }

    /**
     * 报废审批回调
     * @return  string
    */
    public static function dingCallBack () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingCallBack();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}