<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:19:42
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Storage
 * @method bmsNotOperableStoragesByParams(array $params) bmsNotOperableStorages
 * @method bmsNotShipStorageByParams(array $params) bmsNotShipStorage
 * @method getSupplyStorageByParams(array $params) 协同供应商仓库id
 * @method getStorageByStoreIdByParams(array $params) 获取门店仓库
 * @method getStorageByIdsNotAddressByParams(array $params) 获取门店仓库不带地址
 * @method getStorageByIdByParams(array $params) 根据id获取仓库信息
 * @method getStorageAddressByIdByParams(array $params) 根据id获取仓库的地址信息
 * @method getStorageAddressByIdsByParams(array $params) 根据ids获取仓库的地址信息
 * @method getStoragesByIdsByParams(array $params) 根据ids获取仓库信息
 * @method getStorageListByParams(array $params) 获取门店仓库列表
 * @method getStoragesByParams(array $params) 获取仓库列表
 * @method getStoragesBySourceAndUseTypeByParams(array $params) 根据source和useType获取仓库信息
 * @method getStorageByStoreIdsByParams(array $params) 获取门店仓库
 * @method createStorageByStoreByParams(array $params) 创建自用/零售仓库
 * @method createStorageBySupplierByParams(array $params) 创建供应商仓库
 * @method updatedStorageByStoreByParams(array $params) 修改门店信息同步地址信息
 * @method storageSyncByParams(array $params) 用于供应商仓库地址初始化
 * @method getDepartmentByParams(array $params) 得到部门
 * @method getStorageIdsByDepartmentIdsByParams(array $params) 得到部门
 * @method getStorageMapByParams(array $params) getStorageMap
 * @method getAllStorageMapByParams(array $params) getAllStorageMap
 * @method getAdderInfoByParams(array $params) 获取仓库地址
 * @method retrySyncEbsByParams(array $params) 巨沃仓库同步
 * @method getListPageByParams(array $params) 仓库分页列表
 * @method getInfoByParams(array $params) 仓库详情
 * @method saveStorageInfoByParams(array $params) 修改仓库信息
 * @method getSupplyStorageAddressLogsByParams(array $params) 返回供应商对应的仓库地址的数量 supplier_id =&gt; address_count
 * @method headquartersStorageByParams(array $params) 创建职能仓库
 */
class Storage {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Storage";

    /**
     * bmsNotOperableStorages
     * @return  array
    */
    public static function bmsNotOperableStorages () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsNotOperableStorages();
    }

    /**
     * bmsNotShipStorage
     * @return  array
    */
    public static function bmsNotShipStorage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bmsNotShipStorage();
    }

    /**
     * 协同供应商仓库id
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSupplyStorage (int $supplierId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyStorage(["supplierId" => $supplierId]);
    }

    /**
     * 获取门店仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStorageByStoreId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageByStoreId([]);
    }

    /**
     * 获取门店仓库不带地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStorageByIdsNotAddress (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageByIdsNotAddress(["ids" => $ids]);
    }

    /**
     * 根据id获取仓库信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStorageById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageById(["id" => $id]);
    }

    /**
     * 根据id获取仓库的地址信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageAddressById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageAddressById(["id" => $id]);
    }

    /**
     * 根据ids获取仓库的地址信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStorageAddressByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageAddressByIds(["ids" => $ids]);
    }

    /**
     * 根据ids获取仓库信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoragesByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoragesByIds(["ids" => $ids]);
    }

    /**
     * 获取门店仓库列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageList([]);
    }

    /**
     * 获取仓库列表
     * @return  mixed
    */
    public static function getStorages () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorages();
    }

    /**
     * 根据source和useType获取仓库信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoragesBySourceAndUseType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoragesBySourceAndUseType([]);
    }

    /**
     * 获取门店仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStorageByStoreIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageByStoreIds([]);
    }

    /**
     * 创建自用/零售仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createStorageByStore (int $id, string $name, bool $isAddress = false, array $extend = [], int $source = 2) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStorageByStore(["id" => $id, "name" => $name, "isAddress" => $isAddress, "extend" => $extend, "source" => $source]);
    }

    /**
     * 创建供应商仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createStorageBySupplier (int $id, string $name, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStorageBySupplier(["id" => $id, "name" => $name, "extend" => $extend]);
    }

    /**
     * 修改门店信息同步地址信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updatedStorageByStore (array $original, array $attributes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatedStorageByStore(["original" => $original, "attributes" => $attributes]);
    }

    /**
     * 用于供应商仓库地址初始化
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function storageSync (int $storageId, string $city = '', string $province = '', string $area = '', string $address = '', string $userName = '', string $phone = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->storageSync(["storageId" => $storageId, "city" => $city, "province" => $province, "area" => $area, "address" => $address, "userName" => $userName, "phone" => $phone]);
    }

    /**
     * 得到部门
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDepartment (int $departmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartment(["departmentId" => $departmentId]);
    }

    /**
     * 得到部门
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStorageIdsByDepartmentIds (array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageIdsByDepartmentIds(["departmentIds" => $departmentIds]);
    }

    /**
     * getStorageMap
     * @return  array
    */
    public static function getStorageMap () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStorageMap();
    }

    /**
     * getAllStorageMap
     * @return  array
    */
    public static function getAllStorageMap () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStorageMap();
    }

    /**
     * 获取仓库地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdderInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdderInfo([]);
    }

    /**
     * 巨沃仓库同步
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function retrySyncEbs (int $id, string $platCode = 'MenD') {
        return RpcClass::getClass(self::$serviceName, self::$className)->retrySyncEbs(["id" => $id, "platCode" => $platCode]);
    }

    /**
     * 仓库分页列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPage(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 仓库详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo([]);
    }

    /**
     * 修改仓库信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function saveStorageInfo (int $id, string $province, string $city, string $area, string $address, string $userName, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveStorageInfo(["id" => $id, "province" => $province, "city" => $city, "area" => $area, "address" => $address, "userName" => $userName, "phone" => $phone]);
    }

    /**
     * 返回供应商对应的仓库地址的数量 supplier_id =&gt; address_count
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSupplyStorageAddressLogs (array $supplierIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSupplyStorageAddressLogs(["supplierIds" => $supplierIds]);
    }

    /**
     * 创建职能仓库
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function headquartersStorage (int $fromId, string $entityName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->headquartersStorage(["fromId" => $fromId, "entityName" => $entityName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}