<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:19:42
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method autoSetStockRedisByParams(array $params) 自动初始化每日库存map
 * @method esSearchByParams(array $params) 自动初始化每日库存map
 * @method redisDelByParams(array $params) redis信息删除
 * @method redisSetByParams(array $params) redis信息删除
 * @method redisGetByParams(array $params) redis信息读取
 * @method getEsStatusByParams(array $params) es信息读取
 * @method createExpressTypeNameByParams(array $params) 创建新的快递类型
 * @method cliByParams(array $params) 每天0点自动刷新发货通知单，调拨单子单时间状态
 * @method autoSendSmsByParams(array $params) 每天10点发送短信
 * @method delayedDinRobotPushByParams(array $params) 机器人发送通知
 * @method censusExceptionOrderByParams(array $params) 异常工单提醒
 * @method censusPurchaseOrderByParams(array $params) 超期未处理订单提醒
 * @method rebuildCacheByParams(array $params) 增加重新建立Cache缓存接口
 * @method setEsSetByParams(array $params) 开启/关闭对应es查询
 * @method delLogisticStatusByParams(array $params) 删除对应物流单号的key
 * @method getLogisticStatusByParams(array $params) 查询对应物流单号的key
 * @method setStockOutNameByParams(array $params) setStockOutName
 * @method setStockInNameByParams(array $params) setStockInName
 * @method pushStockDiffByParams(array $params) 异步钉钉推送
 * @method stockByParams(array $params) 库存核对
 * @method autoCreateNoByParams(array $params) 自动初始化每日单号
 * @method autoCreateSkuNoByParams(array $params) 自动初始化每月物料编码
 * @method autoCreateNoTodayByParams(array $params) 自动初始化今日单号
 * @method autoCreateNoTodayExtraByParams(array $params) 自动初始化今日单号
 * @method updateAllocationShipNoticeByParams(array $params) 已完成的调拨单生成对应发货通知单
 * @method syncAllocationByParams(array $params) syncAllocation
 * @method commonAllocationShipByParams(array $params) commonAllocationShip
 * @method allocationMsgShipByParams(array $params) allocationMsgShip
 * @method syncStockLiveByParams(array $params) syncStockLive
 * @method updateStorageFromIdAndNameByParams(array $params) 更新仓库部门id与仓库名称
 * @method updateStorageStoreTypeByParams(array $params) 更新仓库门店品牌
 * @method updatePartUnshipAllocationItemsByParams(array $params) 调拨单同步
 * @method updateShipNoticeByParams(array $params) 发货通知单误推送状态更新
 * @method updateReceiveReceiveTypeByParams(array $params) receive_type 异常收货单更新
 * @method updateReceiveExceptionTypeByParams(array $params) 异常工单单据类型错误更新
 * @method payByParams(array $params) 更新付款
 * @method syncExpressTypeByParams(array $params) 巨沃物流同步
 * @method dumpLockByParams(array $params) 报废单手动补货
 * @method addRestockDemandByParams(array $params) 报废单手动补货
 */
class Common {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Common";

    /**
     * 自动初始化每日库存map
     * @return  bool
    */
    public static function autoSetStockRedis () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSetStockRedis();
    }

    /**
     * 自动初始化每日库存map
     * @return  array
    */
    public static function esSearch () {
        return RpcClass::getClass(self::$serviceName, self::$className)->esSearch();
    }

    /**
     * redis信息删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function redisDel (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->redisDel(["type" => $type]);
    }

    /**
     * redis信息删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function redisSet (string $key) {
        return RpcClass::getClass(self::$serviceName, self::$className)->redisSet(["key" => $key]);
    }

    /**
     * redis信息读取
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function redisGet (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->redisGet(["type" => $type]);
    }

    /**
     * es信息读取
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getEsStatus (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getEsStatus(["name" => $name]);
    }

    /**
     * 创建新的快递类型
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createExpressTypeName (string $name, string $logisticName, int $id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createExpressTypeName(["name" => $name, "logisticName" => $logisticName, "id" => $id]);
    }

    /**
     * 每天0点自动刷新发货通知单，调拨单子单时间状态
     * @return  bool
    */
    public static function cli () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cli();
    }

    /**
     * 每天10点发送短信
     * @return  bool
    */
    public static function autoSendSms () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSendSms();
    }

    /**
     * 机器人发送通知
     * @return  bool
    */
    public static function delayedDinRobotPush () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delayedDinRobotPush();
    }

    /**
     * 异常工单提醒
     * @return  mixed
    */
    public static function censusExceptionOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->censusExceptionOrder();
    }

    /**
     * 超期未处理订单提醒
     * @return  bool
    */
    public static function censusPurchaseOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->censusPurchaseOrder();
    }

    /**
     * 增加重新建立Cache缓存接口
     * @return  bool
    */
    public static function rebuildCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->rebuildCache();
    }

    /**
     * 开启/关闭对应es查询
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function setEsSet (string $name, int $set) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setEsSet(["name" => $name, "set" => $set]);
    }

    /**
     * 删除对应物流单号的key
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delLogisticStatus (string $logisticNo, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delLogisticStatus(["logisticNo" => $logisticNo, "type" => $type]);
    }

    /**
     * 查询对应物流单号的key
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getLogisticStatus (string $logisticNo, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLogisticStatus(["logisticNo" => $logisticNo, "type" => $type]);
    }

    /**
     * setStockOutName
     * @return  mixed
    */
    public static function setStockOutName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStockOutName();
    }

    /**
     * setStockInName
     * @return  mixed
    */
    public static function setStockInName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStockInName();
    }

    /**
     * 异步钉钉推送
     * @return  mixed
    */
    public static function pushStockDiff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushStockDiff();
    }

    /**
     * 库存核对
     * @return  bool
    */
    public static function stock () {
        return RpcClass::getClass(self::$serviceName, self::$className)->stock();
    }

    /**
     * 自动初始化每日单号
     * @return  void
    */
    public static function autoCreateNo () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoCreateNo();
    }

    /**
     * 自动初始化每月物料编码
     * @return  void
    */
    public static function autoCreateSkuNo () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoCreateSkuNo();
    }

    /**
     * 自动初始化今日单号
     * @return  void
    */
    public static function autoCreateNoToday () {
         RpcClass::getClass(self::$serviceName, self::$className)->autoCreateNoToday();
    }

    /**
     * 自动初始化今日单号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function autoCreateNoTodayExtra (string $no) {
         RpcClass::getClass(self::$serviceName, self::$className)->autoCreateNoTodayExtra(["no" => $no]);
    }

    /**
     * 已完成的调拨单生成对应发货通知单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function updateAllocationShipNotice (string $beginDate = '', string $endDate = '') {
         RpcClass::getClass(self::$serviceName, self::$className)->updateAllocationShipNotice(["beginDate" => $beginDate, "endDate" => $endDate]);
    }

    /**
     * syncAllocation
     * @return  void
    */
    public static function syncAllocation () {
         RpcClass::getClass(self::$serviceName, self::$className)->syncAllocation();
    }

    /**
     * commonAllocationShip
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function commonAllocationShip (array $allocationIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->commonAllocationShip(["allocationIds" => $allocationIds]);
    }

    /**
     * allocationMsgShip
     * @return  mixed
    */
    public static function allocationMsgShip () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allocationMsgShip();
    }

    /**
     * syncStockLive
     * @return  mixed
    */
    public static function syncStockLive () {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncStockLive();
    }

    /**
     * 更新仓库部门id与仓库名称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateStorageFromIdAndName (int $storageId = 0, string $storageName = '', string $entityName = '', int $fromId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStorageFromIdAndName(["storageId" => $storageId, "storageName" => $storageName, "entityName" => $entityName, "fromId" => $fromId]);
    }

    /**
     * 更新仓库门店品牌
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateStorageStoreType (int $storageId = 0, string $storeType = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStorageStoreType(["storageId" => $storageId, "storeType" => $storeType]);
    }

    /**
     * 调拨单同步
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updatePartUnshipAllocationItems (array $allocationIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePartUnshipAllocationItems(["allocationIds" => $allocationIds]);
    }

    /**
     * 发货通知单误推送状态更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateShipNotice (array $noticeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateShipNotice(["noticeIds" => $noticeIds]);
    }

    /**
     * receive_type 异常收货单更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateReceiveReceiveType (array $receiveIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateReceiveReceiveType(["receiveIds" => $receiveIds]);
    }

    /**
     * 异常工单单据类型错误更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateReceiveExceptionType (int $id, string $sendType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateReceiveExceptionType(["id" => $id, "sendType" => $sendType]);
    }

    /**
     * 更新付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function pay (string $type, string $orderNo, string $status,  $paidMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pay(["type" => $type, "orderNo" => $orderNo, "status" => $status, "paidMoney" => $paidMoney]);
    }

    /**
     * 巨沃物流同步
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function syncExpressType (int $id = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncExpressType(["id" => $id]);
    }

    /**
     * 报废单手动补货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function dumpLock (int $demandId, int $staffId, array $data, bool $overflow = false, int $storeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->dumpLock(["demandId" => $demandId, "staffId" => $staffId, "data" => $data, "overflow" => $overflow, "storeId" => $storeId]);
    }

    /**
     * 报废单手动补货
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addRestockDemand (int $restockId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRestockDemand(["restockId" => $restockId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}