<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-09 17:19:42
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Allocation
 * @method allocationCountByParams(array $params) 获取调拨单数量
 * @method listByParams(array $params) 调拨单列表
 * @method detailByParams(array $params) 获取调拨单详情
 * @method detailByNoByParams(array $params) 获取调拨单号详情
 * @method searchAllocationsByParams(array $params) searchAllocations
 * @method itemListByParams(array $params) 调拨单子单据列表--分页
 * @method batchCreateByParams(array $params) 批量创建调拨单,只保留这一个接口
 */
class Allocation {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Allocation";

    /**
     * 获取调拨单数量
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO
    */
    public static function allocationCount (?\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $allocationSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allocationCount($allocationSearchCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO"
        );
    }

    /**
     * 调拨单列表
     * @return  array
    */
    public static function list (?\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $allocationPaginateSearchCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($allocationPaginateSearchCMD);
    }

    /**
     * 获取调拨单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO"
        );
    }

    /**
     * 获取调拨单号详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO
    */
    public static function detailByNo (string $allocationNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detailByNo(["allocationNo" => $allocationNo]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO"
        );
    }

    /**
     * searchAllocations
     * @return  array
    */
    public static function searchAllocations (?\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $allocationSearchCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchAllocations($allocationSearchCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]"
        );
    }

    /**
     * 调拨单子单据列表--分页
     * @return  array
    */
    public static function itemList (?\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $allocationItemPaginateSearchCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList($allocationItemPaginateSearchCMD);
    }

    /**
     * 批量创建调拨单,只保留这一个接口
     * @return  array
    */
    public static function batchCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $allocationBatchCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchCreate($allocationBatchCreateCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}