<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-02 18:05:04
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Material
 * @method getSkuInfoByKeywordByParams(array $params) 获取物料sku信息
 * @method getSkuInfoByIdsByParams(array $params) 根据物料skuId获取物料信息
 * @method getSkuListByParams(array $params) 根据条件获取物料信息
 * @method getSkuListBySkuCodesByParams(array $params) 根据条件获取物料信息
 * @method getSkuIdsByParams(array $params) 根据条件获取物料信息
 * @method getSkuListByPageByParams(array $params) 分页获取物料信息
 * @method getMaterialSkusWithCategoryByParams(array $params) 分页获取productSku表中商品信息，附带3级分类信息
 * @method listByParams(array $params) 获取物料列表
 * @method detailByParams(array $params) 获取物料详情
 * @method firstByNameByParams(array $params) 获取物料详情
 * @method findMaterialByCodeByParams(array $params) 获取单条物料信息
 * @method getMaterialIdsByParams(array $params) 通过物料ids得到物料
 * @method getSkusByNameByParams(array $params) 得到物料基本信息
 * @method findMaterialsByNameAndIsFixedAssetByParams(array $params) 通过物料名和是否固定资产得到物料
 * @method getMaterialByNameByParams(array $params) 通过物料名得到物料
 * @method checkBatchMaterialByParams(array $params) 检验物料名和code是否存在
 * @method getMaterialIdsByStoreTypesByParams(array $params) 通过门店类型得到物料ids
 * @method getSkusByMaterialIdByParams(array $params) 通过materialId得到物料sku
 * @method getMaterialWithSkusByParams(array $params) 得到物料和其sku
 * @method bomListByParams(array $params) 得到bom列表
 * @method getInfoByParams(array $params) 通过各种条件获取materialIds
 * @method getMaterialWithSkusBySourcePageByParams(array $params) 通过source获取物料及sku
 * @method searchMaterialByPageByParams(array $params) 获取物料分页列表 剔除无上架sku的物料
 * @method setSkuLocationByParams(array $params) 设置库位
 * @method getSkuLocationInfoByParams(array $params) 根据skuId storageId 查询库位信息
 */
class Material {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Material";

    /**
     * 获取物料sku信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuInfoByKeyword (array $source, string $keyword) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuInfoByKeyword(["source" => $source, "keyword" => $keyword]);
    }

    /**
     * 根据物料skuId获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuInfoByIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuInfoByIds(["skuIds" => $skuIds]);
    }

    /**
     * 根据条件获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList([]);
    }

    /**
     * 根据条件获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSkuListBySkuCodes () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuListBySkuCodes([]);
    }

    /**
     * 根据条件获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuIds (array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIds(["params" => $params]);
    }

    /**
     * 分页获取物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuListByPage (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuListByPage(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialSkusWithCategory (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialSkusWithCategory(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取物料列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取物料详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 获取物料详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function firstByName (string $name, int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firstByName(["name" => $name, "source" => $source]);
    }

    /**
     * 获取单条物料信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function findMaterialByCode (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findMaterialByCode(["code" => $code]);
    }

    /**
     * 通过物料ids得到物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialIds (array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialIds(["params" => $params]);
    }

    /**
     * 得到物料基本信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByName (string $name, int $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByName(["name" => $name, "source" => $source]);
    }

    /**
     * 通过物料名和是否固定资产得到物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function findMaterialsByNameAndIsFixedAsset (string $name, int $isFixedAsset = null, int $source = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findMaterialsByNameAndIsFixedAsset(["name" => $name, "isFixedAsset" => $isFixedAsset, "source" => $source]);
    }

    /**
     * 通过物料名得到物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialByName (string $name, array $source) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialByName(["name" => $name, "source" => $source]);
    }

    /**
     * 检验物料名和code是否存在
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function checkBatchMaterial (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkBatchMaterial(["data" => $data]);
    }

    /**
     * 通过门店类型得到物料ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialIdsByStoreTypes (array $storeTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialIdsByStoreTypes(["storeTypes" => $storeTypes]);
    }

    /**
     * 通过materialId得到物料sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkusByMaterialId (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusByMaterialId(["id" => $id, "status" => $status]);
    }

    /**
     * 得到物料和其sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialWithSkus (array $source = [], string $isProcess = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialWithSkus(["source" => $source, "isProcess" => $isProcess]);
    }

    /**
     * 得到bom列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function bomList (array $params, int $page, int $pageSize, array $materialIds = [], array $storeTypeMaterialIds = [], array $bomSkuIds = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bomList(["params" => $params, "page" => $page, "pageSize" => $pageSize, "materialIds" => $materialIds, "storeTypeMaterialIds" => $storeTypeMaterialIds, "bomSkuIds" => $bomSkuIds]);
    }

    /**
     * 通过各种条件获取materialIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo([]);
    }

    /**
     * 通过source获取物料及sku
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaterialWithSkusBySourcePage (int $source, int $page, int $pageSize, array $params = [], int $isStockTaking = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialWithSkusBySourcePage(["source" => $source, "page" => $page, "pageSize" => $pageSize, "params" => $params, "isStockTaking" => $isStockTaking]);
    }

    /**
     * 获取物料分页列表 剔除无上架sku的物料
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function searchMaterialByPage (int $isFixedAsset, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterialByPage(["isFixedAsset" => $isFixedAsset, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 设置库位
     * @return  bool
    */
    public static function setSkuLocation (\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSkuLocation\Cmd\MaterialSkuLocationCmd $materialSkuLocationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setSkuLocation($materialSkuLocationCmd);
    }

    /**
     * 根据skuId storageId 查询库位信息
     * @return  array
    */
    public static function getSkuLocationInfo (?\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSkuLocation\DTO\SkuLocationModelWhereDTO $skuLocationModelWhereDTO = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuLocationInfo($skuLocationModelWhereDTO);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}