<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-03 15:08:57
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseOrder
 * @method retailOrderCreateByParams(array $params) retailOrderCreate
 * @method listByParams(array $params) 列表
 * @method detailByParams(array $params) 详情
 * @method itemListByParams(array $params) 明细列表
 * @method updateByParams(array $params) 更新
 * @method createApproveByParams(array $params) 发起审批
 * @method approveByParams(array $params) 更新审批
 * @method submitByParams(array $params) 提交(生成发货通知单)
 * @method submitMqByParams(array $params) 提交(生成发货通知单)
 * @method closeByParams(array $params) 关闭
 * @method getItemsByItemIdsByParams(array $params) 根据订单明细ids获取发货明细信息
 * @method getByIdsByParams(array $params) 根据发货ids获取发货信息
 * @method firstByIdByParams(array $params) 根据发货ids获取发货信息
 * @method firstByIdWithAdvanceByParams(array $params) 根据发货ids获取发货信息
 * @method updateCostPriceByParams(array $params) 更新采购价(预付款后)
 * @method updateOrderItemByParams(array $params) 修改明细信息(预付款前)
 * @method updatePrepaidRateByParams(array $params) 用于补漏的物料库存初始化
 * @method getUpdateByInfosByParams(array $params) 获取更新人s
 * @method getPurchaseOrderByParams(array $params) 获取采购单详情
 */
class PurchaseOrder {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "PurchaseOrder";

    /**
     * retailOrderCreate
     * @return  bool
    */
    public static function retailOrderCreate (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseOrder\CMD\RetailAddCMD $retailAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retailOrderCreate($retailAddCMD);
    }

    /**
     * 列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }

    /**
     * 明细列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $page = 1, int $pageSize = 10, int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["page" => $page, "pageSize" => $pageSize, "orderId" => $orderId]);
    }

    /**
     * 更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function update (int $updateBy, int $orderId, int $supplierId, string $remark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["updateBy" => $updateBy, "orderId" => $orderId, "supplierId" => $supplierId, "remark" => $remark]);
    }

    /**
     * 发起审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createApprove (int $updateBy, int $orderId, string $processInstanceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createApprove(["updateBy" => $updateBy, "orderId" => $orderId, "processInstanceId" => $processInstanceId]);
    }

    /**
     * 更新审批
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approve (string $processInstanceId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approve(["processInstanceId" => $processInstanceId, "status" => $status]);
    }

    /**
     * 提交(生成发货通知单)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function submit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->submit([]);
    }

    /**
     * 提交(生成发货通知单)
     * @return  bool
    */
    public static function submitMq () {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitMq();
    }

    /**
     * 关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function close (int $updateBy, int $orderId, array $orderItemIds, int $closeCount) {
        return RpcClass::getClass(self::$serviceName, self::$className)->close(["updateBy" => $updateBy, "orderId" => $orderId, "orderItemIds" => $orderItemIds, "closeCount" => $closeCount]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemsByItemIds (array $itemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemsByItemIds(["itemIds" => $itemIds]);
    }

    /**
     * 根据发货ids获取发货信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByIds(["ids" => $ids]);
    }

    /**
     * 根据发货ids获取发货信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function firstById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firstById(["id" => $id]);
    }

    /**
     * 根据发货ids获取发货信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function firstByIdWithAdvance (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firstByIdWithAdvance(["id" => $id]);
    }

    /**
     * 更新采购价(预付款后)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateCostPrice (int $updateBy, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCostPrice(["updateBy" => $updateBy, "data" => $data]);
    }

    /**
     * 修改明细信息(预付款前)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updateOrderItem (int $updateBy, array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderItem(["updateBy" => $updateBy, "data" => $data]);
    }

    /**
     * 用于补漏的物料库存初始化
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function updatePrepaidRate (int $updateBy, int $orderId, float $prepaidRate) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePrepaidRate(["updateBy" => $updateBy, "orderId" => $orderId, "prepaidRate" => $prepaidRate]);
    }

    /**
     * 获取更新人s
     * @return  array
    */
    public static function getUpdateByInfos () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpdateByInfos();
    }

    /**
     * 获取采购单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPurchaseOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseOrder([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}