<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-03 15:08:57
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseDemand
 * @method createRetailByParams(array $params) 零售需求单创建
 * @method createSelfByParams(array $params) 自用需求单创建
 * @method getDemandListByParams(array $params) 需求单列表
 * @method getDemandListByStoreIdsByParams(array $params) 需求单列表
 * @method batchDealByParams(array $params) 批量处理
 * @method retailBatchDealByParams(array $params) 零售批量处理
 * @method batchCloseByParams(array $params) 批量关闭
 * @method itemListByParams(array $params) 明细列表
 * @method getItemByItemIdsByParams(array $params) 根据需求单明细ids获取需求单明细信息
 * @method getPurchaseDemandItemsByParams(array $params) 获取需求单明细
 * @method getOneByParams(array $params) 通过需求单id得到一个需求单
 * @method callbackDingProcessByParams(array $params) 钉钉回调处理
 * @method findItemOrFailByDemandIdByParams(array $params) 通过需求单id得到一个需求单详情列表
 * @method getPurchaseDemandsByIdsByParams(array $params) 通过需求单ids得到一个需求单列表
 * @method getDemandSByStoreIdAndTypeByParams(array $params) 通过门店类型和门店id得到一个需求单
 * @method purchaseForecastByParams(array $params) 采购预测
 * @method unsetPurchaseForecastByParams(array $params) 失效预测
 * @method unsetCacheByParams(array $params) 采购预测缓存清空
 */
class PurchaseDemand {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "PurchaseDemand";

    /**
     * 零售需求单创建
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO
    */
    public static function createRetail (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $demandAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createRetail($demandAddCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO"
        );
    }

    /**
     * 自用需求单创建
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO
    */
    public static function createSelf (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $demandAddCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createSelf($demandAddCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO"
        );
    }

    /**
     * 需求单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandList (int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandList(["storeId" => $storeId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 需求单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandListByStoreIds (array $storeIds = [], int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandListByStoreIds(["storeIds" => $storeIds, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 批量处理
     * @return  bool
    */
    public static function batchDeal (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $demandDealCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeal($demandDealCMD);
    }

    /**
     * 零售批量处理
     * @return  array
    */
    public static function retailBatchDeal (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $demandDealCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->retailBatchDeal($demandDealCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\RetailDealDTO[]"
        );
    }

    /**
     * 批量关闭
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchClose (int $updateBy, array $demandItemIds, string $closeReason, int $closeType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClose(["updateBy" => $updateBy, "demandItemIds" => $demandItemIds, "closeReason" => $closeReason, "closeType" => $closeType]);
    }

    /**
     * 明细列表
     * @return  array
    */
    public static function itemList (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandItemListQueryCMD $demandItemListQueryCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList($demandItemListQueryCMD);
    }

    /**
     * 根据需求单明细ids获取需求单明细信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemByItemIds (array $itemIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemByItemIds(["itemIds" => $itemIds]);
    }

    /**
     * 获取需求单明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPurchaseDemandItems () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseDemandItems([]);
    }

    /**
     * 通过需求单id得到一个需求单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOne (int $demandId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOne(["demandId" => $demandId]);
    }

    /**
     * 钉钉回调处理
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function callbackDingProcess (string $eventType, string $type, string $processInstanceId, string $result = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackDingProcess(["eventType" => $eventType, "type" => $type, "processInstanceId" => $processInstanceId, "result" => $result]);
    }

    /**
     * 通过需求单id得到一个需求单详情列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function findItemOrFailByDemandId (int $demandId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findItemOrFailByDemandId(["demandId" => $demandId]);
    }

    /**
     * 通过需求单ids得到一个需求单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPurchaseDemandsByIds (array $demandIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPurchaseDemandsByIds(["demandIds" => $demandIds]);
    }

    /**
     * 通过门店类型和门店id得到一个需求单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getDemandSByStoreIdAndType (int $storeId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDemandSByStoreIdAndType(["storeId" => $storeId, "type" => $type]);
    }

    /**
     * 采购预测
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseForecastListDTO
    */
    public static function purchaseForecast (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->purchaseForecast(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseForecastListDTO"
        );
    }

    /**
     * 失效预测
     * @return  bool
    */
    public static function unsetPurchaseForecast (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\UnsetPurchaseForecastListCMD $unsetPurchaseForecastListCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unsetPurchaseForecast($unsetPurchaseForecastListCMD);
    }

    /**
     * 采购预测缓存清空
     * @return  bool
    */
    public static function unsetCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->unsetCache();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}