<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 13:54:23
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PurchaseRefund
 * @method createPurchaseRefundByParams(array $params) 退款单创建
 * @method submitPurchaseRefundByParams(array $params) 退款单提交/完成
 * @method getRefundItemCountByParams(array $params) 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
 * @method updatePurchaseRefundByParams(array $params) 更新退款单
 * @method getDetailByParams(array $params) 获取退款单子单
 * @method getItemsByParams(array $params) getItems
 * @method getListPaginationByParams(array $params) getListPagination
 * @method getListByParams(array $params) getList
 * @method getRefundTaxByParams(array $params) 根据refundId 来计算退款的总金额，不含税，以及税额
 * @method getCreateInfoByParams(array $params) 退款单创建前信息
 * @method approvalRevokeByParams(array $params) 审批单撤回
 * @method updateStatusByParams(array $params) 更新状态
 * @method dingCallBackByParams(array $params) 退款单审批回调
 */
class PurchaseRefund {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "PurchaseRefund";

    /**
     * 退款单创建
     * @return  mixed
    */
    public static function createPurchaseRefund (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateCMD $purchaseRefundCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPurchaseRefund($purchaseRefundCreateCMD);
    }

    /**
     * 退款单提交/完成
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function submitPurchaseRefund (int $refundId, int $updatedBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitPurchaseRefund(["refundId" => $refundId, "updatedBy" => $updatedBy]);
    }

    /**
     * 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRefundItemCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRefundItemCount([]);
    }

    /**
     * 更新退款单
     * @return  bool
    */
    public static function updatePurchaseRefund (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundUpdateCMD $purchaseRefundUpdateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePurchaseRefund($purchaseRefundUpdateCMD);
    }

    /**
     * 获取退款单子单
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundInfoDTO
    */
    public static function getDetail (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundInfoCMD $purchaseRefundInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getDetail($purchaseRefundInfoCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundInfoDTO"
        );
    }

    /**
     * getItems
     * @return  array
    */
    public static function getItems () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItems();
    }

    /**
     * getListPagination
     * @return  array
    */
    public static function getListPagination () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListPagination();
    }

    /**
     * getList
     * @return  array
    */
    public static function getList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getList();
    }

    /**
     * 根据refundId 来计算退款的总金额，不含税，以及税额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRefundTax () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRefundTax([]);
    }

    /**
     * 退款单创建前信息
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoDTO
    */
    public static function getCreateInfo (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateInfoCMD $purchaseRefundCreateInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCreateInfo($purchaseRefundCreateInfoCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoDTO"
        );
    }

    /**
     * 审批单撤回
     * @return  bool
    */
    public static function approvalRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundApprovalRevokeCMD $purchaseRefundApprovalRevokeCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approvalRevoke($purchaseRefundApprovalRevokeCMD);
    }

    /**
     * 更新状态
     * @return  bool
    */
    public static function updateStatus (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundUpdateStatusCMD $purchaseRefundUpdateStatusCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus($purchaseRefundUpdateStatusCMD);
    }

    /**
     * 退款单审批回调
     * @return  string
    */
    public static function dingCallBack () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dingCallBack();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}