<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-13 13:54:23
 */
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Inventory
 * @method dailyAutoReportByParams(array $params) 每日盘点情况通知
 * @method autoSendCreateNoticeByParams(array $params) 每分钟一次创建盘点任务通知
 * @method missionListByParams(array $params) 盘点任务列表
 * @method missionDetailByParams(array $params) 盘点任务详情
 * @method storeInMissionByParams(array $params) 盘点任务关联门店
 * @method skuInMissionByParams(array $params) 盘点任务关联SKU
 * @method skuInMissionsByParams(array $params) 盘点任务关联skus
 * @method missionCreateByParams(array $params) 新增盘点任务
 * @method missionRevokeByParams(array $params) 盘点任务撤回
 * @method missionProcessByParams(array $params) 盘点进度
 * @method missionProcessRateByParams(array $params) 盘点进度计算
 * @method listByParams(array $params) 门店盘点列表
 * @method resultByParams(array $params) 盘点结果
 * @method detailByParams(array $params) 盘点详情
 * @method itemListByParams(array $params) 盘点明细
 * @method itemAllListByParams(array $params) 所有盘点明细
 * @method saveByParams(array $params) 新增盘点
 * @method stashByParams(array $params) 暂存盘点(自用盘点助手)
 * @method checkApproveStatusByParams(array $params) 验证审核状态
 * @method approveByParams(array $params) 盘点审批通过
 * @method approveReturnByParams(array $params) 盘点审批驳回
 * @method approveRevokeByParams(array $params) 驳回审核 撤回
 * @method noticeByParams(array $params) 盘点提醒
 * @method differenceByParams(array $params) 盘点差异
 * @method getAllItemsByInventoryIdByParams(array $params) 获取指定盘点ID的所有item信息
 * @method getInventoryItemsSortByCategoryByParams(array $params) 分类排序返回盘点数据
 * @method getSkuidsSortByCategoryByParams(array $params) 分类排序返回skuids数据
 * @method recheckByParams(array $params) 被驳回后提交盘点结果
 * @method missionsDetailByParams(array $params) 获取指定盘点任务ids的详情
 * @method getItemSkuIdsByParams(array $params) 获取inventory items
 */
class Inventory {
    private static string $serviceName = "HimoSupplyChain";

    private static string $className = "Inventory";

    /**
     * 每日盘点情况通知
     * @return  mixed
    */
    public static function dailyAutoReport () {
        return RpcClass::getClass(self::$serviceName, self::$className)->dailyAutoReport();
    }

    /**
     * 每分钟一次创建盘点任务通知
     * @return  mixed
    */
    public static function autoSendCreateNotice () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSendCreateNotice();
    }

    /**
     * 盘点任务列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function missionList (int $page = 1, int $pageSize = 10, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionList(["page" => $page, "pageSize" => $pageSize, "orderType" => $orderType]);
    }

    /**
     * 盘点任务详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function missionDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionDetail([]);
    }

    /**
     * 盘点任务关联门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function storeInMission (int $missionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeInMission(["missionId" => $missionId]);
    }

    /**
     * 盘点任务关联SKU
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function skuInMission (int $missionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuInMission(["missionId" => $missionId]);
    }

    /**
     * 盘点任务关联skus
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function skuInMissions (array $missionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skuInMissions(["missionIds" => $missionIds]);
    }

    /**
     * 新增盘点任务
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function missionCreate (array $storeIds, int $createBy, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionCreate(["storeIds" => $storeIds, "createBy" => $createBy, "orderType" => $orderType]);
    }

    /**
     * 盘点任务撤回
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function missionRevoke (int $missionId, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionRevoke(["missionId" => $missionId, "updateBy" => $updateBy]);
    }

    /**
     * 盘点进度
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function missionProcess (int $page = 1, int $pageSize = 10, int $missionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionProcess(["page" => $page, "pageSize" => $pageSize, "missionId" => $missionId]);
    }

    /**
     * 盘点进度计算
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function missionProcessRate (int $missionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionProcessRate(["missionId" => $missionId]);
    }

    /**
     * 门店盘点列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "storeId" => $storeId]);
    }

    /**
     * 盘点结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function result (string $orderType, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->result(["orderType" => $orderType, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 盘点详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function detail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail([]);
    }

    /**
     * 盘点明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemList (int $inventoryId, int $page = 1, int $pageSize = 10, bool $adjust = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemList(["inventoryId" => $inventoryId, "page" => $page, "pageSize" => $pageSize, "adjust" => $adjust]);
    }

    /**
     * 所有盘点明细
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function itemAllList (array $inventoryIds, bool $adjust = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->itemAllList(["inventoryIds" => $inventoryIds, "adjust" => $adjust]);
    }

    /**
     * 新增盘点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function save (int $createBy, int $storeId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["createBy" => $createBy, "storeId" => $storeId, "skuInfos" => $skuInfos]);
    }

    /**
     * 暂存盘点(自用盘点助手)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function stash (int $createBy, int $storeId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stash(["createBy" => $createBy, "storeId" => $storeId, "skuInfos" => $skuInfos]);
    }

    /**
     * 验证审核状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkApproveStatus (array $inventoryIds, string $approveStatus) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkApproveStatus(["inventoryIds" => $inventoryIds, "approveStatus" => $approveStatus]);
    }

    /**
     * 盘点审批通过
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approve (array $inventoryIds, int $approveBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approve(["inventoryIds" => $inventoryIds, "approveBy" => $approveBy]);
    }

    /**
     * 盘点审批驳回
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approveReturn (array $inventoryIds, int $approveBy, string $remark) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approveReturn(["inventoryIds" => $inventoryIds, "approveBy" => $approveBy, "remark" => $remark]);
    }

    /**
     * 驳回审核 撤回
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function approveRevoke (array $inventoryIds, int $approveBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->approveRevoke(["inventoryIds" => $inventoryIds, "approveBy" => $approveBy]);
    }

    /**
     * 盘点提醒
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function notice (int $storeId, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->notice(["storeId" => $storeId, "orderType" => $orderType]);
    }

    /**
     * 盘点差异
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function difference (int $page = 1, int $pageSize = 10, string $orderType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->difference(["page" => $page, "pageSize" => $pageSize, "orderType" => $orderType]);
    }

    /**
     * 获取指定盘点ID的所有item信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllItemsByInventoryId (int $inventoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllItemsByInventoryId(["inventoryId" => $inventoryId]);
    }

    /**
     * 分类排序返回盘点数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getInventoryItemsSortByCategory (int $inventoryId, bool $isPaginate = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventoryItemsSortByCategory(["inventoryId" => $inventoryId, "isPaginate" => $isPaginate]);
    }

    /**
     * 分类排序返回skuids数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSkuidsSortByCategory (array $skuids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuidsSortByCategory(["skuids" => $skuids]);
    }

    /**
     * 被驳回后提交盘点结果
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function recheck (int $inventoryId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->recheck(["inventoryId" => $inventoryId, "skuInfos" => $skuInfos]);
    }

    /**
     * 获取指定盘点任务ids的详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function missionsDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->missionsDetail([]);
    }

    /**
     * 获取inventory items
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getItemSkuIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemSkuIds([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}