<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bmsNotOperableStoragesByParams(array $params)
 * @method bmsNotShipStorageByParams(array $params)
 * @method getSupplyStorageByParams(array $params)
 * @method getStorageByStoreIdByParams(array $params)
 * @method getStorageByIdsNotAddressByParams(array $params)
 * @method getStorageByIdByParams(array $params)
 * @method getStorageAddressByIdByParams(array $params)
 * @method getStorageAddressByIdsByParams(array $params)
 * @method getStoragesByIdsByParams(array $params)
 * @method getStorageListByParams(array $params)
 * @method getStoragesByParams(array $params)
 * @method getStoragesBySourceAndUseTypeByParams(array $params)
 * @method getStorageByStoreIdsByParams(array $params)
 * @method createStorageByStoreByParams(array $params)
 * @method createStorageBySupplierByParams(array $params)
 * @method updatedStorageByStoreByParams(array $params)
 * @method storageSyncByParams(array $params)
 * @method getDepartmentByParams(array $params)
 * @method getStorageIdsByDepartmentIdsByParams(array $params)
 * @method getStorageMapByParams(array $params)
 * @method getAllStorageMapByParams(array $params)
 * @method getAdderInfoByParams(array $params)
 * @method retrySyncEbsByParams(array $params)
 * @method getListPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method saveStorageInfoByParams(array $params)
 * @method getSupplyStorageAddressLogsByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取bms不可以操作的仓库
     *
     * @throws  \Exception
     * @return  array
     */
    public static function bmsNotOperableStorages () {
        return self::getClass()->bmsNotOperableStorages();
    }

    /**
     * 获取bms不能发货的仓库
     *
     * @throws  \Exception
     * @return  array
     */
    public static function bmsNotShipStorage () {
        return self::getClass()->bmsNotShipStorage();
    }

    /**
     * 协同供应商仓库id
     *
     * @param  int $supplierId 协同供应商id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplyStorage (int $supplierId) {
        return self::getClass()->getSupplyStorage([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 获取门店仓库
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId([
        ]);
    }

    /**
     * 获取门店仓库不带地址
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageByIdsNotAddress (array $ids) {
        return self::getClass()->getStorageByIdsNotAddress([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据id获取仓库信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageById (int $id) {
        return self::getClass()->getStorageById([
            "id" => $id,
        ]);
    }

    /**
     * 根据id获取仓库的地址信息
     *
     * @param  int $id 仓库ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageAddressById (int $id) {
        return self::getClass()->getStorageAddressById([
            "id" => $id,
        ]);
    }

    /**
     * 根据ids获取仓库的地址信息
     *
     * @param  array $ids 仓库IDs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageAddressByIds (array $ids) {
        return self::getClass()->getStorageAddressByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据ids获取仓库信息
     *
     * @param  array $ids 仓库ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoragesByIds (array $ids) {
        return self::getClass()->getStoragesByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $storeIds 门店ids [ require false ]
     * @support  array $source 仓库归属方 1是总仓，2是门店，3是供应商, 4总部职能 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 [ require false ]
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 [ require false ]
     * @support  string $name 仓库名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageList () {
        return self::getClass()->getStorageList([
        ]);
    }

    /**
     * 获取仓库列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * 根据source和useType获取仓库信息
     *
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoragesBySourceAndUseType () {
        return self::getClass()->getStoragesBySourceAndUseType([
        ]);
    }

    /**
     * 获取门店仓库
     *
     * @support  array $storeIds 门店ids [ require false ]
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓, 3供应商 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageByStoreIds () {
        return self::getClass()->getStorageByStoreIds([
        ]);
    }

    /**
     * 创建自用/零售仓库
     *
     * @param  int $id 门店id [ require true ]
     * @param  string $name 门店名 [ require true ]
     * @param  bool $isAddress 是否更新地址 [ require false ]
     * @param  array $extend 扩展信息 [ require false ]
     * @param  int $source 仓库类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStorageByStore (int $id, string $name, bool $isAddress = false, array $extend = [], int $source = 2) {
        return self::getClass()->createStorageByStore([
            "id" => $id,
            "name" => $name,
            "isAddress" => $isAddress,
            "extend" => $extend,
            "source" => $source,
        ]);
    }

    /**
     * 创建供应商仓库
     *
     * @param  int $id 供应商id [ require true ]
     * @param  string $name 供应商名 [ require true ]
     * @param  array $extend 供应仓库收货地址 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStorageBySupplier (int $id, string $name, array $extend) {
        return self::getClass()->createStorageBySupplier([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 修改门店信息同步地址信息
     *
     * @param  array $original 原始数据 [ require true ]
     * @param  array $attributes 修改后的数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatedStorageByStore (array $original, array $attributes) {
        return self::getClass()->updatedStorageByStore([
            "original" => $original,
            "attributes" => $attributes,
        ]);
    }

    /**
     * 用于供应商仓库地址初始化
     *
     * @param  int $storageId 仓库id [ require true ]
     * @param  string $province 省份 [ require false ]
     * @param  string $city 市 [ require false ]
     * @param  string $area 区县 [ require false ]
     * @param  string $address 详细地址 [ require false ]
     * @param  string $userName 收货人 [ require false ]
     * @param  string $phone 联系方式 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storageSync (int $storageId, string $city = '', string $province = '', string $area = '', string $address = '', string $userName = '', string $phone = '') {
        return self::getClass()->storageSync([
            "storageId" => $storageId,
            "city" => $city,
            "province" => $province,
            "area" => $area,
            "address" => $address,
            "userName" => $userName,
            "phone" => $phone,
        ]);
    }

    /**
     * 得到部门
     *
     * @support  int $departmentId 部门id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartment () {
        return self::getClass()->getDepartment([
        ]);
    }

    /**
     * 得到部门
     *
     * @support  array $departmentIds 部门ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageIdsByDepartmentIds () {
        return self::getClass()->getStorageIdsByDepartmentIds([
        ]);
    }

    /**
     * 获取全部仓库
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageMap () {
        return self::getClass()->getStorageMap();
    }

    /**
     * getAllStorageMap
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStorageMap () {
        return self::getClass()->getAllStorageMap();
    }

    /**
     * 获取仓库地址
     *
     * @support  int $storageId 仓库id [ require false ]
     * @support  array $storageIds 仓库ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAdderInfo () {
        return self::getClass()->getAdderInfo([
        ]);
    }

    /**
     * 巨沃仓库同步
     *
     * @param  int $id 仓库id [ require true ]
     * @param  string $platCode 平台类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retrySyncEbs (int $id, string $platCode = 'MenD') {
        return self::getClass()->retrySyncEbs([
            "id" => $id,
            "platCode" => $platCode,
        ]);
    }

    /**
     * 仓库分页列表
     *
     * @support  int $id 仓库id [ require false ]
     * @support  array $source 仓库类型[1是大江东仓,2是门店,3是供应商,4总部] [ require false ]
     * @support  array $useTypes 仓库用途 [1零售仓,2自用仓,3零售仓,4职能仓库&#039;] [ require false ]
     * @support  int $useType 仓库用途 [1零售仓,2自用仓,3零售仓,4职能仓库&#039;] [ require false ]
     * @support  int $fromId 门店id/部门id/供应商id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListPage (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getListPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 仓库详情
     *
     * @support  int $id 门店id/部门id/供应商id [ require false ]
     * @support  bool $address 是否携带地址组 [ require false ]
     * @support  int $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo () {
        return self::getClass()->getInfo([
        ]);
    }

    /**
     * 修改仓库信息
     *
     * @support  int $id 仓库id [ require true ]
     * @support  string $province 省份 [ require true ]
     * @support  string $city 市 [ require true ]
     * @support  string $area 区县 [ require true ]
     * @support  string $address 详细地址 [ require true ]
     * @support  string $userName 收货人 [ require true ]
     * @support  string $phone 联系方式 [ require true ]
     * @support  bool $expedited 是否立即发货 [ require false ]
     * @support  int $selfLeadTime 自用发货期限 [ require false ]
     * @support  string $storeStartTime 门店开业时间 [ require false ]
     * @support  string $storeShippingTime 门店最晚发货时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveStorageInfo () {
        return self::getClass()->saveStorageInfo([
        ]);
    }

    /**
     * 返回供应商对应的仓库地址的数量 supplier_id =&gt; address_count
     *
     * @param  array $supplierIds 供应商ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplyStorageAddressLogs (array $supplierIds = []) {
        return self::getClass()->getSupplyStorageAddressLogs([
            "supplierIds" => $supplierIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}