<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method runAssetCardTaskByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardTaskCmd $params)
 * @method saveAssetCardByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $params)
 */
class FixedAssets {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 固定资产同步-队列使用
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardTaskCmd $saveAssetCardTaskCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function runAssetCardTask (\Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardTaskCmd $saveAssetCardTaskCmd) {
        return self::getClass()->runAssetCardTask($saveAssetCardTaskCmd);
    }


    /**
     * 建卡出库
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $saveAssetCardOutCmd
     * @throws  \Exception
     * @return  array
     */
    public static function saveAssetCard (\Mainto\Bridge\Structs\HimoSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $saveAssetCardOutCmd) {
        return self::getClass()->saveAssetCard($saveAssetCardOutCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'FixedAssets');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'FixedAssets');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}