<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method restockSubmitByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSaveCMD $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSearchCMD $params)
 */
class Restock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交补货单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSaveCMD $saveCMD
     * @throws  \Exception
     * @return  array
     */
    public static function restockSubmit (\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSaveCMD $saveCMD) {
        return self::getClass()->restockSubmit($saveCMD);
    }


    /**
     * 补货单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSearchCMD $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (\Mainto\Bridge\Structs\HimoSupplyChain\Restock\CMD\RestockSearchCMD $cmd) {
        return self::getClass()->detail($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Restock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Restock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}