<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allocationCountByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method searchAllocationsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $params)
 * @method itemListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $params)
 * @method batchCreateByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $params)
 */
class Allocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取调拨单数量
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO
     */
    public static function allocationCount (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->allocationCount($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO"
        );
    }


    /**
     * 调拨单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD) {
        return self::getClass()->list($CMD);
    }


    /**
     * 获取调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO"
        );
    }

    /**
     * 获取调拨单号详情
     *
     * @param  string $allocationNo 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO
     */
    public static function detailByNo (string $allocationNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detailByNo([
                            "allocationNo" => $allocationNo,
                        ]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO"
        );
    }

    /**
     * searchAllocations
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]
     */
    public static function searchAllocations (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchAllocations($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]"
        );
    }


    /**
     * 调拨单子单据列表--分页
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD) {
        return self::getClass()->itemList($CMD);
    }


    /**
     * 批量创建调拨单,只保留这一个接口
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]
     */
    public static function batchCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->batchCreate($cmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}