<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRetailByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $params)
 * @method createSelfByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $params)
 * @method getDemandListByParams(array $params)
 * @method getDemandListByStoreIdsByParams(array $params)
 * @method batchDealByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $params)
 * @method retailBatchDealByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandItemListQueryCMD $params)
 * @method getItemByItemIdsByParams(array $params)
 * @method getPurchaseDemandItemsByParams(array $params)
 * @method getOneByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method findItemOrFailByDemandIdByParams(array $params)
 * @method getPurchaseDemandsByIdsByParams(array $params)
 * @method getDemandSByStoreIdAndTypeByParams(array $params)
 * @method purchaseForecastByParams(array $params)
 */
class PurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * TODO 零售创建过程可以跟自用合在一起。只是后面的流程不一样。
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO
     */
    public static function createRetail (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createRetail($cmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO"
        );
    }


    /**
     * 自用需求单创建
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO
     */
    public static function createSelf (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandAddCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createSelf($cmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseDemandDTO"
        );
    }


    /**
     * 需求单列表
     *
     * @param  int $storeId 门店id [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  array $source 单据类型:1物料2成品3原料 [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 单据状态 [ require false ]
     * @support  int $createBy 申请人工号 [ require false ]
     * @support  int $skuId 物料skuId [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $storeId = 0, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "storeId" => $storeId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 需求单列表
     *
     * @param  array $storeIds 门店id [ require false ]
     * @support  array $departmentIds 部门id [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  array $source 单据类型:1物料2成品3原料 [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 单据状态 [ require false ]
     * @support  int $createBy 申请人工号 [ require false ]
     * @support  int $skuId 物料skuId [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandListByStoreIds (array $storeIds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandListByStoreIds([
            "storeIds" => $storeIds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 批量处理
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $dealCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDeal (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $dealCMD) {
        return self::getClass()->batchDeal($dealCMD);
    }


    /**
     * 零售批量处理
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $dealCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\RetailDealDTO[]
     */
    public static function retailBatchDeal (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandDealCMD $dealCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->retailBatchDeal($dealCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\RetailDealDTO[]"
        );
    }


    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @param  int $closeType 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchClose (int $updateBy, array $demandItemIds, string $closeReason, int $closeType) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
            "closeType" => $closeType,
        ]);
    }

    /**
     * 明细列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandItemListQueryCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\CMD\DemandItemListQueryCMD $cmd) {
        return self::getClass()->itemList($cmd);
    }


    /**
     * 根据需求单明细ids获取需求单明细信息
     *
     * @param  array $itemIds 需求单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemByItemIds (array $itemIds) {
        return self::getClass()->getItemByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 获取需求单明细
     *
     * @support  array $itemIds 需求单itemids [ require false ]
     * @support  string $demandNo 需求单No [ require false ]
     * @support  array $demandIds 需求单Ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseDemandItems () {
        return self::getClass()->getPurchaseDemandItems([
        ]);
    }

    /**
     * 通过需求单id得到一个需求单
     *
     * @param  int $demandId 需求单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOne (int $demandId) {
        return self::getClass()->getOne([
            "demandId" => $demandId,
        ]);
    }

    /**
     * 钉钉回调处理
     *
     * @param  string $eventType 事件类型 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $result 钉钉回调结果 [ require false ]
     * @param  string $processInstanceId 钉钉实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callbackDingProcess (string $eventType, string $type, string $processInstanceId, string $result = '') {
        return self::getClass()->callbackDingProcess([
            "eventType" => $eventType,
            "type" => $type,
            "processInstanceId" => $processInstanceId,
            "result" => $result,
        ]);
    }

    /**
     * 通过需求单id得到一个需求单详情列表
     *
     * @param  int $demandId 需求单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findItemOrFailByDemandId (int $demandId) {
        return self::getClass()->findItemOrFailByDemandId([
            "demandId" => $demandId,
        ]);
    }

    /**
     * 通过需求单ids得到一个需求单列表
     *
     * @param  array $demandIds 需求单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseDemandsByIds (array $demandIds) {
        return self::getClass()->getPurchaseDemandsByIds([
            "demandIds" => $demandIds,
        ]);
    }

    /**
     * 通过门店类型和门店id得到一个需求单
     *
     * @param  int $storeId 需求单ids [ require true ]
     * @param  string $type 门店类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandSByStoreIdAndType (int $storeId, string $type) {
        return self::getClass()->getDemandSByStoreIdAndType([
            "storeId" => $storeId,
            "type" => $type,
        ]);
    }

    /**
     * 采购预测
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseForecastListDTO
     */
    public static function purchaseForecast (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->purchaseForecast([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseDemand\DTO\PurchaseForecastListDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}